/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.ResultSet;
import java.sql.SQLException;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.dbconnection.DatabaseControl;
import servermate.failover.FailoverManager;
import servermate.failover.SocketHelper;
import servermate.failover.handback.HandbackReceiver;
import servermate.failover.pushpull.PushWebstartTask;

public class FailoverServerSocket {
    private static final String MASTER_DUMP = "C:\\mysql\\5.5\\master_dump.sql";
    public static final String REQUEST_DETAILS = "Request Master Details:";
    public static final String UPDATE_DETAILS = "Update Master Details:";
    public static final String BEGIN_MERGE = "BEGIN MERGE";
    public static final String REQUEST_DATA = "Request Master Data:";
    public static final String WEBSTART_ME = "Demand Webstart";
    public static final String VERSION = "Version:";
    private ServerSocket socket;
    private FailoverManager manager;

    FailoverServerSocket(ServerSocket yourSocket) {
        this.socket = yourSocket;
    }

    FailoverServerSocket(FailoverManager yourManager) {
        this.manager = yourManager;
        try {
            this.socket = new ServerSocket(this.manager.getSetup().getMasterPort());
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot create servermate failover server socket.", (Throwable)ex);
        }
    }

    void start() {
        if (this.socket == null) {
            OrderMate.LOG.error("Cannot create socket, failover cannot start.");
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!FailoverServerSocket.this.socket.isClosed()) {
                    Socket incomingSocket = null;
                    try {
                        incomingSocket = FailoverServerSocket.this.socket.accept();
                    }
                    catch (IOException ex) {
                        OrderMate.LOG.error("Cannot accept incoming failover communique:", (Throwable)ex);
                    }
                    if (incomingSocket == null) continue;
                    FailoverServerSocket.this.handleIncomingSocket(incomingSocket);
                    try {
                        incomingSocket.close();
                    }
                    catch (IOException ex) {
                        OrderMate.LOG.error("Cannot close off incoming failover socket:", (Throwable)ex);
                    }
                }
            }
        }).start();
    }

    void stop() {
        if (this.socket == null) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Issue closing off socket:", (Throwable)ex);
        }
    }

    private void handleIncomingSocket(Socket incomingSocket) {
        if (incomingSocket == null) {
            return;
        }
        SocketHelper helper = new SocketHelper(incomingSocket);
        String message = helper.receiveMessage();
        if (message == null) {
            return;
        }
        if (this.handleSlavePoke(helper, message)) {
            return;
        }
        if (this.handleUpdateDetailsRequest(helper, message)) {
            return;
        }
        if (this.handleDetailsRequest(helper, message)) {
            return;
        }
        if (this.handleDataRequest(helper, message)) {
            return;
        }
        if (this.handleDataMerge(helper, message)) {
            return;
        }
        if (this.handleWebStart(helper, message)) {
            return;
        }
        helper.sendMessage("Don't understand");
        OrderMate.LOG.warn("Unknown command from failover:" + message);
    }

    private boolean handleSlavePoke(SocketHelper helper, String message) {
        if (message.startsWith("SLAVE:")) {
            long id = 0L;
            try {
                id = Long.parseLong(message.substring("SLAVE:".length()));
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.warn("Cannot get id of terminal poking master:", (Throwable)ex);
            }
            if (id != 0L) {
                Terminal terminal = (Terminal)PersistenceManager.getByID((long)id, Terminal.class);
                if (terminal != null) {
                    if (!FailoverManager.getInstance().containsSlave(terminal)) {
                        helper.sendMessage(VERSION + OrderMate.VERSION);
                    }
                    FailoverManager.getInstance().slavePokedYou(terminal);
                } else {
                    OrderMate.LOG.warn("Poked by unknown Terminal of ID:" + id);
                }
            }
            return true;
        }
        return false;
    }

    synchronized boolean handleUpdateDetailsRequest(SocketHelper helper, String message) {
        if (message.startsWith(UPDATE_DETAILS)) {
            OrderMate.LOG.info("Updating slave details.");
            this.sendMasterDetails(helper);
            return true;
        }
        return false;
    }

    synchronized boolean handleDetailsRequest(SocketHelper helper, String message) {
        if (message.startsWith(REQUEST_DETAILS)) {
            OrderMate.LOG.info("Slave has requested master details:" + message);
            DatabaseControl dc = new DatabaseControl(true);
            try {
                dc.execute("FLUSH TABLES WITH READ LOCK;");
            }
            catch (SQLException ex) {
                OrderMate.LOG.error("Cannot lock the database tables:", (Throwable)ex);
            }
            this.sendMasterDetails(helper);
            if (this.manager != null) {
                this.manager.pushText("Exporting Database...", true, Color.ORANGE);
            }
            if (this.dumpMasterDB()) {
                if (this.manager != null) {
                    this.manager.pushText("Finished Exporting Database", true, Color.GREEN);
                }
            } else if (this.manager != null) {
                this.manager.pushText("Cannot export database - NOT EXPORTED", true, Color.RED);
            }
            try {
                dc.execute("UNLOCK TABLES;");
            }
            catch (SQLException ex) {
                OrderMate.LOG.error("Cannot lock the database tables:", (Throwable)ex);
            }
            dc.closeConnection();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMasterDetails(SocketHelper helper) {
        DatabaseControl otherDc = new DatabaseControl(true);
        ResultSet rs = null;
        StringBuilder SB = new StringBuilder();
        try {
            rs = otherDc.executeQuery("SHOW MASTER STATUS;");
            String fileField = "";
            String positionField = "";
            if (rs.first()) {
                fileField = rs.getString("File");
                positionField = rs.getString("Position");
            }
            String username = Config.getDecryptedStringValue((String)"database_username");
            String password = Config.getDecryptedStringValue((String)"database_password");
            SB.append("LOG_FILE=").append(fileField).append(":").append("LOG_POS=").append(positionField).append(":").append("DB_USER=").append(username).append(":").append("DB_PWD=").append(password);
        }
        catch (SQLException ex) {
            OrderMate.LOG.error("cannot read in master status", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    OrderMate.LOG.error("Cannot close off result set:", (Throwable)ex);
                }
            }
        }
        helper.sendMessage(SB.toString());
    }

    private boolean dumpMasterDB() {
        try {
            String username = Config.getDecryptedStringValue((String)"database_username");
            String password = Config.getDecryptedStringValue((String)"database_password");
            String toExecute = "C:\\mysql\\5.5\\bin\\mysqldump.exe -u" + username + " -p" + password + " ordermate_prod >" + MASTER_DUMP;
            Process process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", toExecute});
            process.waitFor();
            return true;
        }
        catch (IOException e) {
            OrderMate.LOG.error("Cannot dump database", (Throwable)e);
        }
        catch (InterruptedException e) {
            OrderMate.LOG.error("Cannot dump database", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleDataRequest(SocketHelper helper, String message) {
        if (message.startsWith(REQUEST_DATA)) {
            OrderMate.LOG.info("Slave wants my data:" + message);
            File file = new File(MASTER_DUMP);
            if (file.exists()) {
                FileInputStream fin = null;
                BufferedReader reader = null;
                try {
                    fin = new FileInputStream(file);
                    reader = new BufferedReader(new InputStreamReader(fin));
                    String line = reader.readLine();
                    while (line != null) {
                        helper.sendMessage(line);
                        line = reader.readLine();
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Interrupted while transmitting dump", (Throwable)ex);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                            fin.close();
                        }
                        catch (IOException ex) {
                            OrderMate.LOG.error("Cannot close off stream:", (Throwable)ex);
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean handleDataMerge(SocketHelper helper, String message) {
        if (message.startsWith(BEGIN_MERGE)) {
            HandbackReceiver merger = new HandbackReceiver(helper);
            merger.doMerge();
            return true;
        }
        return false;
    }

    private synchronized boolean handleWebStart(SocketHelper helper, String message) {
        if (message.equals(WEBSTART_ME)) {
            try {
                new PushWebstartTask(helper).runLocal();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot write out the webstart", (Throwable)ex);
            }
            return true;
        }
        return false;
    }
}

