/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover;

import au.com.ordermate.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import servermate.failover.FailoverManager;
import servermate.failover.FailoverPanel;
import servermate.failover.FailoverStatusChecker;

public class SlavePanel
extends FailoverPanel {
    private static final String TITLE = "Slave";
    Signal pullWebstart;
    private JButton pullWebstartButton;
    private boolean requestingFailover = false;

    public SlavePanel(FailoverManager yourManager) {
        super(yourManager);
    }

    @Override
    protected void setupButtons(JPanel holder) {
        super.setupButtons(holder);
        holder.add(new JSeparator());
        this.pullWebstartButton = this.makeButton("Pull Webstart", this.pullWebstart);
        holder.add(this.pullWebstartButton);
    }

    @Override
    public void setButtonsEnabled(boolean b) {
        super.setButtonsEnabled(b);
        this.pullWebstartButton.setEnabled(b);
    }

    @Override
    void connectSignals() {
        super.connectSignals();
        this.pullWebstart = Signals.createSignal();
        this.pullWebstart.connect((Object)this.manager, "pullWebstartFromMaster");
    }

    @Override
    void disconnectSignals() {
        super.disconnectSignals();
        this.pullWebstart.disconnect((Object)this.manager);
    }

    @Override
    public Pair<String, Color> getStatus() {
        FailoverStatusChecker checker = new FailoverStatusChecker();
        String value = checker.checkStatus();
        Color colour = null;
        if (value == null) {
            if (this.manager.isConnectedToRealMaster()) {
                value = "Monitoring Failover - Connected to Master";
                colour = Color.BLUE;
            } else {
                value = "Monitoring Failover - Connected to Acting Master";
                colour = Color.magenta;
            }
        } else {
            colour = Color.RED;
        }
        return new Pair((Object)value, (Object)colour);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public void askToFailover() {
        this.requestingFailover = true;
        StringBuilder SB = new StringBuilder("<html><h1 color='Red' align='center'>Attention!</h1>").append("Connection between Servermate and this device has been lost.<br>").append("If other terminals have also experienced a disconnection, <br>").append("it may be that ServerMate is down or unreachable.").append("<br><br>This terminal has been configured to act as a <b>Redundant Server</b><br>").append("which means that it can act as Servermate.<br>").append("Before activating this terminal as ServerMate, please check the following:").append("<ol><li>If ServerMate is running</li>").append("<li>Network connections</li>").append("<li>Failover has been setup correctly</li>").append("<li>The network switch is running</li></ol>").append("<b>Do you wish to activate this terminal as the ServerMate?</b><br><br>").append("If unsure, contact OrderMate Emergency Support immediately on:<br>").append("<b>1300 667 002</b></html>");
        JPanel holder = new JPanel(new BorderLayout());
        JLabel bigLabel = new JLabel(SB.toString());
        JButton activate = new JButton("Activate Redundancy...");
        activate.setAction(new AbstractAction("Activate Redundancy..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(SlavePanel.this, "<html><h2>Are you sure?</h2>", "Activate Redundancy?", 0) == 0) {
                    SlavePanel.this.manager.doFailover();
                }
            }
        });
        holder.add((Component)activate, "South");
        holder.add((Component)bigLabel, "Center");
        this.setPreferredSize(new Dimension(400, 400));
        JPanel centrePanel = this.getCentrePanel();
        centrePanel.removeAll();
        centrePanel.add((Component)holder, "Center");
        centrePanel.revalidate();
        this.setButtonsEnabled(false);
    }

    @Override
    public boolean canConnect() {
        boolean failoverWasRequested = this.requestingFailover;
        JPanel centrePanel = this.getCentrePanel();
        this.setButtonsEnabled(true);
        this.setPreferredSize(new Dimension(400, 100));
        centrePanel.removeAll();
        centrePanel.validate();
        centrePanel.repaint();
        return failoverWasRequested;
    }
}

