/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import ordermate.OrderMate;

public class SocketHelper {
    private int TIMEOUT = 2000;
    private int DEATH_TIMEOUT = 90000;
    private Socket socket;
    private PrintWriter writer;
    private BufferedReader reader;
    private final int port;
    private final String host;

    public SocketHelper(String host, int port) {
        this.port = port;
        this.host = host;
    }

    public SocketHelper(Socket theSocket) {
        this.socket = theSocket;
        this.port = 0;
        this.host = null;
    }

    public boolean reconnect() {
        this.closeOff();
        this.socket = null;
        try {
            this.socket = new Socket();
            this.socket.setSoTimeout(this.DEATH_TIMEOUT);
            this.socket.connect(new InetSocketAddress(this.host, this.port), this.TIMEOUT);
        }
        catch (IOException ex) {
            OrderMate.LOG.warn("Exception while connecting to failover master:", (Throwable)ex);
            this.closeOff();
        }
        return this.isValid();
    }

    public boolean isValid() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    public OutputStream getOutputStream() {
        if (this.socket == null) {
            OrderMate.LOG.error("Cannot get the output stream of a null socket.");
            return null;
        }
        try {
            return this.socket.getOutputStream();
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot get the output stream of the socket.", (Throwable)ex);
            return null;
        }
    }

    public InputStream getInputStream() {
        if (this.socket == null) {
            OrderMate.LOG.error("Cannot get the input stream of a null socket");
            return null;
        }
        try {
            return this.socket.getInputStream();
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot get the output stream of the socket.", (Throwable)ex);
            return null;
        }
    }

    public void sendMessage(String value) {
        if (this.writer == null) {
            try {
                this.writer = new PrintWriter(this.socket.getOutputStream());
            }
            catch (IOException ex) {
                OrderMate.LOG.error("Cannot construct a print writer to write to failover master", (Throwable)ex);
            }
        }
        if (this.writer != null) {
            this.writer.print(value);
            this.writer.print("\n");
            this.writer.flush();
        }
    }

    public String receiveMessage() {
        if (this.reader == null) {
            try {
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            }
            catch (IOException ex) {
                OrderMate.LOG.error("Cannot read in from Master:", (Throwable)ex);
                return null;
            }
        }
        if (this.reader != null) {
            StringBuilder SB = new StringBuilder();
            try {
                SB.append(this.reader.readLine());
                while (this.reader.ready()) {
                    SB.append("\n");
                    SB.append(this.reader.readLine());
                }
            }
            catch (IOException ex) {
                OrderMate.LOG.error("Error reading in string from stream:", (Throwable)ex);
                return null;
            }
            return SB.toString();
        }
        return null;
    }

    public void closeOff() {
        if (this.socket == null) {
            return;
        }
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
        if (this.reader != null) {
            try {
                this.reader.close();
                this.reader = null;
            }
            catch (IOException ex) {
                OrderMate.LOG.error("Cannot close off the failover socket reader.", (Throwable)ex);
            }
        }
        if (!this.socket.isClosed()) {
            try {
                this.socket.getInputStream().close();
                this.socket.getOutputStream().flush();
                this.socket.getOutputStream().close();
                this.socket.close();
            }
            catch (IOException ex) {
                OrderMate.LOG.error("Couldn't close off a socket", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readLinesToFile(File output) {
        FileOutputStream fout = null;
        boolean fine = false;
        try {
            fout = new FileOutputStream(output);
            this.writer = new PrintWriter(fout);
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            String line = this.reader.readLine();
            while (line != null) {
                this.writer.write(line);
                line = this.reader.readLine();
                if (line == null) continue;
                this.writer.write("\r\n");
            }
            fine = true;
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Could not read in / push to file:", (Throwable)ex);
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.flush();
                    fout.flush();
                    this.writer.close();
                    fout.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.warn("Couldn't close off push file:", (Throwable)ex);
                }
            }
        }
        return fine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushBytesFromFile(String fileName) {
        FileInputStream fin = null;
        byte[] bytes = new byte[4096];
        try {
            OutputStream out = this.socket.getOutputStream();
            fin = new FileInputStream(new File(fileName));
            int length = 0;
            while ((length = fin.read(bytes)) != -1) {
                out.write(bytes, 0, length);
                out.flush();
            }
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot read from file to push to socket:", (Throwable)ex);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Cannot close off the file input stream.", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullBytesToFile(String fileName) {
        OutputStream fout = null;
        byte[] bytes = new byte[4096];
        try {
            InputStream stream = this.socket.getInputStream();
            fout = new FileOutputStream(new File(fileName));
            int length = 0;
            while ((length = stream.read(bytes)) != -1) {
                ((FileOutputStream)fout).write(bytes, 0, length);
            }
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot read from file to push to socket:", (Throwable)ex);
        }
        finally {
            if (fout != null) {
                try {
                    fout.flush();
                    ((FileOutputStream)fout).close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Cannot close off the file input stream.", (Throwable)ex);
                }
            }
        }
    }
}

