/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handback;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.failover.FailoverDatabaseRow;
import ordermate.database.misc.TradingDay;
import servermate.failover.SocketHelper;
import servermate.failover.handback.sender.AccountSender;
import servermate.failover.handback.sender.DebtorPaymentSender;
import servermate.failover.handback.sender.DebtorSaleSender;
import servermate.failover.handback.sender.EventLogSender;
import servermate.failover.handback.sender.HandbackSender;

class HandbackTransmitter {
    private SocketHelper helper;
    private List<HandbackSender> senders;

    HandbackTransmitter(SocketHelper yourHelper) {
        this.helper = yourHelper;
        this.senders = new ArrayList<HandbackSender>();
        this.senders.add(new AccountSender());
        this.senders.add(new DebtorSaleSender());
        this.senders.add(new DebtorPaymentSender());
        this.senders.add(new EventLogSender());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRows() {
        OrderMate.LOG.info("Sending rows...");
        this.writeOutFailoverRows();
        List<TradingDay> days = this.getDaysToSend();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(this.helper.getOutputStream());
            for (TradingDay nextDay : days) {
                this.deliverTradingDay(out, nextDay);
                OrderMate.LOG.info("Trading Day delivered:" + nextDay);
            }
            this.deliverTradingDay(out, null);
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Couldn't fully write out the data", (Throwable)ex);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Cannot close off the output stream.", (Throwable)ex);
                }
            }
        }
        OrderMate.LOG.info("Finished sending trading day data");
    }

    List<TradingDay> getDaysToSend() {
        ObjectQuery query = Query.select(FailoverDatabaseRow.class).equals(FailoverDatabaseRow.Properties.DB_TABLE, (Object)"finance_trading_day");
        FailoverDatabaseRow tradingDayRow = (FailoverDatabaseRow)PersistenceManager.getObject(FailoverDatabaseRow.class, (String)query.toString(), null);
        if (tradingDayRow == null) {
            OrderMate.LOG.warn("Cannot find any finance_trading_day failover row. Nothing to merge.");
            return Collections.emptyList();
        }
        query = Query.select(TradingDay.class).greaterThanOrEqual(TradingDay.Properties.ID, (Object)tradingDayRow.getRowId());
        return PersistenceManager.getObjectList(TradingDay.class, (String)query.toString(), null);
    }

    void writeOutFailoverRows() {
        List failoverRows = PersistenceManager.getObjectList(FailoverDatabaseRow.class, (String)Query.select(FailoverDatabaseRow.class).orderBy(FailoverDatabaseRow.Properties.DB_TABLE).toString(), null);
        StringBuilder SB = new StringBuilder();
        for (FailoverDatabaseRow row : failoverRows) {
            SB.append(row.getDbTable()).append("=").append(row.getRowId()).append(";");
        }
        this.helper.sendMessage(SB.toString());
        OrderMate.LOG.info("Failover rows written");
    }

    void deliverTradingDay(ObjectOutputStream out, TradingDay day) {
        try {
            out.writeBoolean(day != null);
            if (day != null) {
                out.writeObject(day);
                for (HandbackSender sender : this.senders) {
                    this.sendData(sender, day, out);
                }
            }
            out.flush();
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot create an output stream to send children.", (Throwable)ex);
            return;
        }
    }

    private <T extends PersistentObject> void sendData(HandbackSender<T> sender, TradingDay day, ObjectOutputStream out) throws IOException {
        List<T> objects = sender.getObjectsToSendBack(day);
        String clazz = sender.getSendingClazz().getCanonicalName();
        out.writeObject(clazz);
        out.writeInt(objects.size());
        for (PersistentObject obj : objects) {
            sender.prepareObjectToSendBack(obj);
            out.writeObject(obj);
        }
    }
}

