/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handback.merger;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.util.Date;
import ordermate.database.finance.Shift;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountLocaliser;
import ordermate.database.users.User;
import servermate.failover.handback.Handback;
import servermate.failover.handback.merger.AccountIdClarifier;
import servermate.failover.handback.merger.TradingDayMerger;
import servermate.failover.handback.strategy.HandbackStrategy;

public class AccountHandbackMerger
extends TradingDayMerger<Account> {
    @Override
    public String getMergingType() {
        return "Account";
    }

    @Override
    public void setToDefault(Handback<Account> handback) {
        HandbackStrategy strategy = HandbackStrategy.Add;
        if (handback.canOverride() && handback.getExisting() != null) {
            strategy = handback.getIncoming().getCreationDateTime().equals(handback.getExisting().getCreationDateTime()) ? HandbackStrategy.Override : HandbackStrategy.Add;
        }
        handback.setStrategy(strategy);
    }

    @Override
    protected boolean canOverride(Account incoming, Account existing) {
        return existing != null && incoming.getAccountType().equals((Object)existing.getAccountType());
    }

    @Override
    public String getIncomingType(Handback<Account> handback) {
        return handback.getIncoming().getAccountType().getCapitilizedLabel();
    }

    @Override
    public Price getIncomingTotal(Handback<Account> handback) {
        return handback.getIncoming().getSavedTotal();
    }

    @Override
    public Date getIncomingDate(Handback<Account> handback) {
        return handback.getIncoming().getCreationDateTime();
    }

    @Override
    public Price getExistingTotal(Handback<Account> handback) {
        if (handback.getExisting() != null) {
            return handback.getExisting().getSavedTotal();
        }
        return null;
    }

    @Override
    public Date getExistingDate(Handback<Account> handback) {
        if (handback.getExisting() != null) {
            return handback.getExisting().getCreationDateTime();
        }
        return null;
    }

    @Override
    public void localise(Account incoming, Account existing) {
        TradingDay localTradingDay = this.tradingDay;
        Shift shift = null;
        if (existing != null) {
            localTradingDay = existing.getTradingDay();
            shift = existing.getShift();
        } else {
            shift = incoming.getShift();
            if (shift != null && (shift = Shift.getShift((TradingDay)localTradingDay, (String)incoming.getShift().getName())) == null) {
                shift = Shift.createShift((TradingDay)localTradingDay, (ConfigShift)ConfigShift.getConfigShiftWithName((String)incoming.getShift().getName()));
            }
            if (shift == null) {
                shift = Shift.getFirstShiftForDate((Date)localTradingDay.getDate());
            }
        }
        AccountLocaliser localiser = new AccountLocaliser(localTradingDay, shift);
        localiser.localiseAccount(incoming);
    }

    @Override
    public void destroy(Account objectToDestroy) {
        if (objectToDestroy != null) {
            objectToDestroy.nukeAccount();
        }
    }

    @Override
    public void save(Account objectToSave) {
        objectToSave.lock(User.getSystemUser());
        objectToSave.save();
        objectToSave.unlock();
    }

    @Override
    public void clearIds(Account objectToClear) {
        AccountIdClarifier clarifier = new AccountIdClarifier();
        clarifier.clearIds(objectToClear);
    }

    @Override
    protected Class<Account> getClazz() {
        return Account.class;
    }

    @Override
    protected PropertiedObject.Property<TradingDay> getTradingDayProperty() {
        return Account.Properties.TRADING_DAY;
    }
}

