/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handback.merger;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Collection;
import java.util.List;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.Account;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import servermate.failover.handback.merger.IdClarifier;

class AccountIdClarifier
extends IdClarifier<Account> {
    AccountIdClarifier() {
    }

    @Override
    protected void clearChildrenIds(Account parent) {
        List txns;
        if (parent instanceof PhoneAccount) {
            this.clearPhoneAccountIds((PhoneAccount)parent);
        }
        if ((txns = (List)PropertiedObject.PropsHelper.getPropertyValue((PropertiedObject)parent, (PropertiedObject.Property)Account.Properties.ALL_FINANCE_TRANSACTIONS)) != null) {
            for (FinanceTransaction txn : txns) {
                this.clearFinanceTransaction(txn);
            }
        }
        this.clearPriceAdjustment(parent.getPriceAdjustments());
        for (SalesLineItem item : parent.getAllItems()) {
            this.clearSalesLineItem(item);
        }
    }

    private void clearFinanceTransaction(FinanceTransaction txn) {
        this.clearId((PersistentObject)txn);
        this.clearList(txn.getDebtorPayments());
        this.clearList(txn.getDebtorSales());
    }

    private void clearSalesLineItem(SalesLineItem item) {
        this.clearId((PersistentObject)item);
        this.clearList(item.getSalesItemQuantities());
        if (item instanceof SalesCombo) {
            for (SalesItem nextItem : item.getSalesItems()) {
                this.clearSalesLineItem((SalesLineItem)nextItem);
            }
        } else {
            this.clearComponents(((SalesItem)item).getComponentList());
        }
        this.clearPriceAdjustment(item.getPriceAdjustments());
        this.clearList((List)PropertiedObject.PropsHelper.getPropertyValue((PropertiedObject)item, (PropertiedObject.Property)SalesItem.Properties.ITEM_ADJUSTMENT_LINKS));
    }

    private void clearComponents(List<SalesComponent> comps) {
        for (SalesComponent comp : comps) {
            this.clearId((PersistentObject)comp);
            this.clearList(comp.getPriceAdjustmentUsages());
        }
    }

    private void clearPriceAdjustment(Collection<SalesPriceAdjustment> adjs) {
        for (SalesPriceAdjustment adj : adjs) {
            this.clearId((PersistentObject)adj);
            this.clearList(adj.getPriceAdjustmentUsages());
        }
    }

    private void clearPhoneAccountIds(PhoneAccount account) {
        if (account.isDelivered()) {
            Delivery delivery = account.getDelivery();
            this.clearId((PersistentObject)delivery);
        }
    }
}

