/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handback.merger;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.database.misc.SystemProperty;
import servermate.failover.handback.merger.HandbackMerger;

abstract class DateMerger<T extends PersistentObject>
extends HandbackMerger<T, Date> {
    DateMerger() {
    }

    protected Date getToDate(Date from) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(from);
        cal.add(5, 1);
        cal.add(14, -1);
        return cal.getTime();
    }

    @Override
    protected Date getEquivalentParentObject(List<T> incoming) {
        Date date = (Date)PropertiedObject.PropsHelper.getPropertyValue((PropertiedObject)((PropertiedObject)incoming.get(0)), this.getDateProperty());
        Calendar time = Calendar.getInstance();
        time.setTime(SystemProperty.getInstance().getChangeDayTime());
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(date);
        startDate.set(11, time.get(11));
        startDate.set(12, time.get(12));
        startDate.set(13, time.get(13));
        startDate.set(14, time.get(14));
        return startDate.getTime();
    }

    @Override
    protected List<T> getExisting(Date parentObject) {
        ObjectQuery query = Query.select(this.getClazz());
        query.wherePropertyBetween(this.getDateProperty(), parentObject, this.getToDate(parentObject), SQLDateType.TIMESTAMP);
        return PersistenceManager.getObjectList(this.getClazz(), (String)query.toString());
    }

    protected abstract Class<T> getClazz();

    protected abstract PropertiedObject.Property<Date> getDateProperty();
}

