/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handback.merger;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.util.Date;
import ordermate.database.misc.EventLogLocaliser;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.misc.TradingDay;
import servermate.failover.handback.Handback;
import servermate.failover.handback.merger.TradingDayMerger;
import servermate.failover.handback.strategy.HandbackStrategy;

public class EventLogMerger
extends TradingDayMerger<EventLogRecord> {
    @Override
    protected void setToDefault(Handback<EventLogRecord> toSet) {
        EventLogRecord existing = toSet.getExisting();
        if (existing == null) {
            toSet.setStrategy(HandbackStrategy.Add);
        } else {
            EventLogRecord incoming = toSet.getIncoming();
            if (existing.getEventDate().equals(incoming.getEventDate()) && existing.getType().equals(incoming.getType()) && existing.getMessage().equals(incoming.getMessage())) {
                toSet.setStrategy(HandbackStrategy.Ignore);
            } else {
                toSet.setStrategy(HandbackStrategy.Add);
            }
        }
    }

    @Override
    protected boolean canOverride(EventLogRecord incoming, EventLogRecord existing) {
        return false;
    }

    @Override
    public String getIncomingType(Handback<EventLogRecord> handback) {
        return handback.getIncoming().getType();
    }

    @Override
    public Price getIncomingTotal(Handback<EventLogRecord> handback) {
        return null;
    }

    @Override
    public Date getIncomingDate(Handback<EventLogRecord> handback) {
        return handback.getIncoming().getEventDate();
    }

    @Override
    public Price getExistingTotal(Handback<EventLogRecord> handback) {
        return null;
    }

    @Override
    public Date getExistingDate(Handback<EventLogRecord> handback) {
        if (handback.getExisting() != null) {
            return handback.getExisting().getEventDate();
        }
        return null;
    }

    @Override
    public void localise(EventLogRecord incoming, EventLogRecord existing) {
        EventLogLocaliser.localiseEventLog((EventLogRecord)incoming, (TradingDay)this.tradingDay);
    }

    @Override
    public void destroy(EventLogRecord objectToDestroy) {
        PersistenceManager.delete((PersistentObject)objectToDestroy);
    }

    @Override
    public void save(EventLogRecord objectToSave) {
        objectToSave.save();
    }

    @Override
    public void clearIds(EventLogRecord objectToClear) {
        PersistenceManager.setID((PersistentObject)objectToClear, null);
    }

    @Override
    protected Class<EventLogRecord> getClazz() {
        return EventLogRecord.class;
    }

    @Override
    protected PropertiedObject.Property<TradingDay> getTradingDayProperty() {
        return EventLogRecord.Properties.TRADING_DAY;
    }

    @Override
    public String getMergingType() {
        return "Event Log Record";
    }
}

