/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handback.merger;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.TradingDay;
import servermate.failover.handback.Handback;
import servermate.failover.handback.gui.HandbackMergerDialog;
import servermate.failover.handback.strategy.HandbackStrategy;

public abstract class HandbackMerger<T extends PersistentObject, P> {
    private List<Handback<T>> listOfHandbacks;
    protected TradingDay tradingDay;

    public void doMerge(List<T> incoming) {
        if (incoming.size() == 0) {
            OrderMate.LOG.info("Zero objects to merge.");
            return;
        }
        P parentObject = this.getEquivalentParentObject(incoming);
        List<T> localIncoming = this.sortList(incoming);
        List<T> existing = this.getExisting(parentObject);
        this.listOfHandbacks = this.createListOfHandbacks(localIncoming, existing);
        this.compareAndMerge();
    }

    public abstract String getMergingType();

    protected abstract P getEquivalentParentObject(List<T> var1);

    protected abstract List<T> getExisting(P var1);

    protected abstract void setToDefault(Handback<T> var1);

    public void setAllToDefaultStrategy() {
        for (Handback<T> nextHandback : this.listOfHandbacks) {
            this.setToDefault(nextHandback);
        }
    }

    public void setAllToStrategy(HandbackStrategy strategy) {
        for (Handback<T> nextHandback : this.listOfHandbacks) {
            nextHandback.setStrategy(strategy);
        }
    }

    protected List<T> sortList(List<T> toSort) {
        return toSort;
    }

    private List<Handback<T>> createListOfHandbacks(List<T> incoming, List<T> existing) {
        ArrayList<Handback<T>> handbackList = new ArrayList<Handback<T>>();
        for (PersistentObject in : incoming) {
            PersistentObject existingObject = this.getMatchingObject(in, existing);
            handbackList.add(new Handback<PersistentObject>(in, existingObject, this.canOverride(in, existingObject)));
        }
        return handbackList;
    }

    void compareAndMerge() {
        HandbackMergerDialog dialog = new HandbackMergerDialog(this);
        dialog.setVisible(true);
        if (dialog.wasOkPressed()) {
            this.mergify(this.listOfHandbacks);
        }
    }

    protected abstract boolean canOverride(T var1, T var2);

    protected T getMatchingObject(T incoming, List<T> existingTs) {
        for (PersistentObject nextT : existingTs) {
            if (!incoming.getID().equals(nextT.getID())) continue;
            return (T)nextT;
        }
        return null;
    }

    private void mergify(List<Handback<T>> toMerge) {
        for (Handback<T> nextHandback : toMerge) {
            nextHandback.getStrategy().getMerge().merge(nextHandback, this);
        }
    }

    public int getSize() {
        return this.listOfHandbacks.size();
    }

    public Handback get(int row) {
        if (row < 0 || row >= this.listOfHandbacks.size()) {
            return null;
        }
        return this.listOfHandbacks.get(row);
    }

    public abstract String getIncomingType(Handback<T> var1);

    public abstract Price getIncomingTotal(Handback<T> var1);

    public abstract Date getIncomingDate(Handback<T> var1);

    public abstract Price getExistingTotal(Handback<T> var1);

    public abstract Date getExistingDate(Handback<T> var1);

    public abstract void localise(T var1, T var2);

    public abstract void destroy(T var1);

    public abstract void save(T var1);

    public abstract void clearIds(T var1);

    void setHandbacks(List<Handback<T>> handbacks) {
        this.listOfHandbacks = handbacks;
    }

    public void setTradingDay(TradingDay day) {
        this.tradingDay = day;
    }
}

