/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handback.sender;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.misc.TradingDay;
import ordermate.hom.commandqueue.rowrequest.AccountCascade;
import servermate.failover.handback.sender.DateBasedSending;
import servermate.failover.handback.sender.HandbackSender;

public class DebtorSaleSender
implements HandbackSender<DebtorSale> {
    @Override
    public List<DebtorSale> getObjectsToSendBack(TradingDay parentObject) {
        Date fromDate = DateBasedSending.getChangeoverTime(parentObject.getOpenDateTime());
        Date to = DateBasedSending.getToDate(fromDate);
        ObjectQuery query = Query.select(DebtorSale.class);
        query.wherePropertyBetween(DebtorSale.Properties.SALE_DATE, fromDate, to, SQLDateType.TIMESTAMP);
        return PersistenceManager.getObjectList(DebtorSale.class, (String)query.toString());
    }

    @Override
    public void prepareObjectToSendBack(DebtorSale object) {
        AccountCascade cascade = new AccountCascade(PersistenceManager.getPersistenceDelegate());
        cascade.getChildrenToCascade((PersistentObject)object.getSaleAccount());
    }

    @Override
    public Class<DebtorSale> getSendingClazz() {
        return DebtorSale.class;
    }
}

