/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handover;

import java.awt.Color;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import ordermate.OrderMate;
import ordermate.database.failover.FailoverDatabaseRow;
import ordermate.dbconnection.DatabaseControl;
import servermate.ServerMate;
import servermate.ServermatePersistenceSharer;
import servermate.failover.FailoverManager;

public class FailoverHandoverProcess {
    private FailoverManager manager;

    public FailoverHandoverProcess(FailoverManager yourManager) {
        this.manager = yourManager;
    }

    public void begin() {
        this.logAndPush("Stopping Slave");
        this.stopSlave();
        this.logAndPush("Clearing Failing Rows");
        this.clearCurrentFailoverRows();
        this.logAndPush("Recording IDs");
        this.recordCurrentIds();
        this.logAndPush("Setting as Master");
        this.setAsActiveMaster();
        this.logAndPush("Opening RMI Ports");
        this.openRMIPorts();
        this.logAndPush("Starting up Servermate Proper");
        ServerMate.getInstance().startupServermateProper();
    }

    private void logAndPush(String value) {
        OrderMate.LOG.info(value);
        this.manager.pushText(value, true, Color.black);
    }

    private void stopSlave() {
        DatabaseControl dc = new DatabaseControl(true);
        try {
            dc.execute("STOP SLAVE;", new Object[0]);
        }
        catch (SQLException ex) {
            OrderMate.LOG.error("Could not start slave.", (Throwable)ex);
        }
        finally {
            dc.closeConnection();
        }
    }

    private void clearCurrentFailoverRows() {
        DatabaseControl dc = new DatabaseControl(true);
        try {
            dc.execute("truncate config_failover_rows", new Object[0]);
        }
        catch (SQLException ex) {
            OrderMate.LOG.error("Could not clear failover rows.", (Throwable)ex);
        }
        finally {
            dc.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordCurrentIds() {
        String allTables = "SHOW TABLES";
        DatabaseControl db = new DatabaseControl(true);
        HashMap<String, Long> tableMap = new HashMap<String, Long>();
        ResultSet rs = null;
        Long one = 1L;
        try {
            rs = db.executeQuery(allTables);
            if (rs.first()) {
                do {
                    tableMap.put(rs.getString(1), one);
                } while (rs.next());
            }
        }
        catch (SQLException ex) {
            OrderMate.LOG.error("Cannot retrieve table names!", (Throwable)ex);
        }
        finally {
            this.tryCloseOff(rs);
            rs = null;
        }
        String SQL = "SELECT MAX(ID) FROM ";
        for (String nextTable : tableMap.keySet()) {
            try {
                rs = db.executeQuery(SQL + nextTable);
                rs.next();
                tableMap.put(nextTable, rs.getLong(1));
            }
            catch (SQLException ex) {
                OrderMate.LOG.error("Cannot retrieve result for maximum id", (Throwable)ex);
            }
            finally {
                this.tryCloseOff(rs);
                rs = null;
            }
        }
        for (String table : tableMap.keySet()) {
            FailoverDatabaseRow row = new FailoverDatabaseRow(table, (Long)tableMap.get(table));
            row.save();
        }
        db.closeConnection();
        this.manager.getSetup().startFailover();
    }

    private void setAsActiveMaster() {
        this.manager.getSetup().setActingMaster(true);
        this.manager.getSetup().save();
    }

    private void openRMIPorts() {
        try {
            ServermatePersistenceSharer.getInstance().startSharing();
        }
        catch (RemoteException ex) {
            OrderMate.LOG.error("Cannot share Persistence over RMI.");
        }
    }

    private void tryCloseOff(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                OrderMate.LOG.error("Cannot close off result set after getting maximum id", (Throwable)ex);
            }
        }
    }
}

