/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.pushpull;

import au.com.ordermate.util.file.FileUtils;
import au.com.ordermate.util.file.FileZipper;
import java.io.File;
import java.util.Calendar;
import ordermate.OrderMate;
import servermate.failover.SocketHelper;

class WebstartZipHandler {
    private SocketHelper helper;
    private File webstartDir;

    WebstartZipHandler(SocketHelper helper) {
        this.helper = helper;
        File file = FileUtils.findProgramFileDirectory();
        if (file != null) {
            this.webstartDir = new File(FileUtils.toPath((boolean)true, (String[])new String[]{file.getAbsolutePath(), "OrderMate", "Apache Group", "htdocs", "Webstart"}));
            if (!this.webstartDir.exists() && FileUtils.is64BitOperatingSystem() && this.webstartDir.getPath().toLowerCase().contains("(x86)") && !(file = FileUtils.getOtherProgramFilesDirOn64BitSystem((File)file)).getPath().toLowerCase().contains("(x86)")) {
                this.webstartDir = file;
                this.webstartDir = new File(FileUtils.toPath((boolean)true, (String[])new String[]{file.getAbsolutePath(), "OrderMate", "Apache Group", "htdocs", "Webstart"}));
            }
        } else {
            this.webstartDir = null;
        }
    }

    File getWebstartDir() {
        return this.webstartDir;
    }

    public boolean compressWebstart() {
        if (this.webstartDir == null) {
            OrderMate.LOG.error("Cannot zip webstart, program files cannot be found!");
            return false;
        }
        String name = FileZipper.getDefaultName((File)this.webstartDir);
        File zipFile = new File(name);
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        long dodgyFileLength = 50000000L;
        if (!zipFile.exists() || zipFile.length() < dodgyFileLength || zipFile.lastModified() < cal.getTimeInMillis()) {
            FileZipper zipper = new FileZipper();
            return zipper.zipIt(this.webstartDir.toString(), name);
        }
        return true;
    }

    public void pushOutWebstart() {
        this.helper.pushBytesFromFile(FileZipper.getDefaultName((File)this.webstartDir));
    }

    public void pullInWebstart() {
        OrderMate.LOG.info("Pulling in Webstart Zip...");
        String name = FileZipper.getDefaultName((File)this.webstartDir);
        this.helper.pullBytesToFile(name);
        OrderMate.LOG.info("Webstart Zip brought in");
    }

    public boolean decompressWebstart() {
        File webstartZip = new File(FileZipper.getDefaultName((File)this.webstartDir));
        FileZipper zipper = new FileZipper();
        OrderMate.LOG.info("Decompressing:" + webstartZip.getAbsolutePath() + " to " + this.webstartDir.getAbsolutePath());
        return zipper.unzipIt(webstartZip.getAbsolutePath(), this.webstartDir.getAbsolutePath());
    }
}

