/*
 * Decompiled with CFR 0.152.
 */
package servermate.gui;

import au.com.ordermate.guicore.task.Task;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ordermate.SafeRestartTask;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.database.users.User;
import ordermate.gui.dialogs.ProgressDialog;
import servermate.gui.ServerMateFrame;

public class RestartConfirmDialog
extends JDialog {
    private JCheckBox chkOpenCashDraw;
    private JCheckBox chkPrintAccounts;
    private JCheckBox chkKnowRisk;
    private static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();

    public RestartConfirmDialog(final User user) {
        final JButton buttonRestart = new JButton("Restart");
        this.setTitle("OrderMate Safe Shutdown");
        this.setDefaultCloseOperation(1);
        this.setIconImage(ServerMateFrame.ORDERMATE_ICON.getImage());
        JPanel panel = new JPanel(new BorderLayout());
        JPanel chkBoxPanel = new JPanel(new GridLayout(0, 1));
        Border border = BorderFactory.createLineBorder(Color.RED, 15);
        panel.setBorder(border);
        this.chkOpenCashDraw = new JCheckBox("Open Cash Drawers");
        this.chkOpenCashDraw.setSelected(true);
        this.chkOpenCashDraw.setBorderPaintedFlat(true);
        this.chkOpenCashDraw.setVisible(false);
        List terminalList = Terminal.getAllWaiterMateTerminals();
        Iterator iterator = terminalList.iterator();
        while (iterator.hasNext() && !this.chkOpenCashDraw.isVisible()) {
            Terminal terminal = (Terminal)iterator.next();
            if (terminal.getAvailableCashDrawers(user).isEmpty()) continue;
            this.chkOpenCashDraw.setVisible(true);
        }
        this.chkPrintAccounts = new JCheckBox("Print all open accounts");
        this.chkPrintAccounts.setSelected(false);
        this.chkPrintAccounts.setBorderPaintedFlat(true);
        this.chkPrintAccounts.setVisible(false);
        if (!Account.getAllOpenCurrentDayAccount().isEmpty()) {
            this.chkPrintAccounts.setSelected(true);
            this.chkPrintAccounts.setVisible(true);
        }
        this.chkKnowRisk = new JCheckBox("I understand there are risks to perform restarting");
        this.chkKnowRisk.setSelected(false);
        this.chkKnowRisk.setBorderPaintedFlat(true);
        this.chkKnowRisk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RestartConfirmDialog.this.chkKnowRisk.isSelected()) {
                    buttonRestart.setEnabled(true);
                } else {
                    buttonRestart.setEnabled(false);
                }
            }
        });
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/servermate/images/warning.png"));
        JLabel message = new JLabel("<html>There is risk to perform restarting!!!<br><br>This action will restart all terminals and will cause unsaved data loss.<br>Please ensure all data has been saved.</html>", icon, 2);
        message.setFont(new Font("System", 1, 14));
        panel.add((Component)message, "North");
        chkBoxPanel.add(this.chkOpenCashDraw);
        chkBoxPanel.add(this.chkPrintAccounts);
        chkBoxPanel.add(this.chkKnowRisk);
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(buttonRestart);
        buttonPanel.add(Box.createHorizontalStrut(5));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestartConfirmDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(cancelButton);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)buttonPanel, "East");
        panel.add((Component)chkBoxPanel, "Center");
        panel.add((Component)southPanel, "South");
        buttonRestart.setEnabled(false);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)panel, "Center");
        contentPane.setBackground(Color.red);
        this.setSize(650, 330);
        this.setBackground(Color.red);
        this.setLocation(RestartConfirmDialog.SCREEN_SIZE.width / 2 - this.getWidth() / 2, RestartConfirmDialog.SCREEN_SIZE.height / 2 - this.getHeight() / 2);
        buttonRestart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestartConfirmDialog.this.setVisible(false);
                SafeRestartTask task = new SafeRestartTask();
                task.actions(RestartConfirmDialog.this.chkOpenCashDraw.isSelected(), RestartConfirmDialog.this.chkPrintAccounts.isSelected(), user);
                ProgressDialog dialog = new ProgressDialog(null, false, (Task)task);
                RestartConfirmDialog.this.setVisible(false);
                dialog.start();
            }
        });
    }
}

