/*
 * Decompiled with CFR 0.152.
 */
package servermate.gui;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileSystemView;
import servermate.client.rmi.ServerMateEndPointRef;

public class ServerMateInfoDialog
extends JDialog
implements ActionListener {
    private JTextArea infoArea;
    private JButton okButton;
    private JButton saveInfoButton;

    public ServerMateInfoDialog(JFrame frame) {
        super(frame);
        this.setupComponents();
    }

    private void setupComponents() {
        Container cPane = this.getContentPane();
        this.infoArea = new JTextArea(20, 50);
        this.infoArea.setLineWrap(false);
        this.infoArea.setEditable(false);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton("OK");
        buttonPanel.add(this.okButton);
        this.saveInfoButton = new JButton("Save Info");
        buttonPanel.add(this.saveInfoButton);
        this.okButton.addActionListener(this);
        this.saveInfoButton.addActionListener(this);
        cPane.setLayout(new BorderLayout());
        cPane.add((Component)new JScrollPane(this.infoArea), "Center");
        cPane.add((Component)buttonPanel, "South");
        this.setTitle("ServerMate Info");
    }

    void showInfo() {
        String orderMateInfo = ServerMateEndPointRef.getOrderMateInfo();
        if (StringUtils.isEmpty((String)orderMateInfo)) {
            this.infoArea.setText("ServerConnection not available");
        } else {
            this.infoArea.setText(orderMateInfo);
        }
        this.setVisible(true);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
        this.infoArea.setCaretPosition(0);
    }

    private void doOK() {
        this.setVisible(false);
    }

    private void doSave() {
        String text = this.infoArea.getText();
        File saveFile = new File(FileSystemView.getFileSystemView().getHomeDirectory() + File.separator + "ServerMateInfo.txt");
        try {
            FileWriter fWriter = new FileWriter(saveFile);
            fWriter.write(text);
            fWriter.flush();
            fWriter.close();
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn("Couldn't write Info to file.", (Throwable)ex);
        }
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.doOK();
        } else if (source == this.saveInfoButton) {
            this.doSave();
        }
    }
}

