/*
 * Decompiled with CFR 0.152.
 */
package servermate.gui.license;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import ordermate.database.misc.license.License;
import ordermate.database.misc.license.LicenseType;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.beansbinding.Validator;
import servermate.client.security.RMISecurityDetails;
import servermate.gui.license.SilentSecurity;
import servermate.gui.license.SoftwareKeyValidator;

public class LicensePanel
extends JPanel {
    private License license;
    private LicenseHeaderPanel headerPanel;
    private LicenseBodyPanel bodyPanel;
    private LicenseKeyPanel keyPanel;
    private String macAddress = "";
    Signal<?, ?, ?, ?, ?> importedLicense = Signals.createSignal();

    public LicensePanel(License theLicense, boolean adminMode) {
        super(new BorderLayout());
        this.license = theLicense;
        this.headerPanel = new LicenseHeaderPanel();
        this.bodyPanel = new LicenseBodyPanel();
        this.keyPanel = new LicenseKeyPanel();
        this.headerPanel.setEditable(adminMode);
        this.bodyPanel.setEditable(adminMode);
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.bodyPanel, "Center");
        this.add((Component)this.keyPanel, "South");
    }

    public void setLicense(License theLicense) {
        this.license = theLicense;
        this.headerPanel.loadLicense(theLicense);
        this.bodyPanel.loadLicense(theLicense);
        this.keyPanel.loadLicense(theLicense);
    }

    public License saveLicense() {
        Validator.Result result = this.headerPanel.validateGui();
        if (result == null) {
            result = this.bodyPanel.validateGui();
        }
        if (result == null) {
            result = this.keyPanel.validateGui();
        }
        if (result != null) {
            JOptionPane.showMessageDialog(this, result.getDescription());
            return this.license;
        }
        this.headerPanel.saveLicense(this.license);
        this.bodyPanel.saveLicense(this.license);
        this.keyPanel.saveLicense(this.license);
        return this.license;
    }

    public License getLicense() {
        return this.license;
    }

    public String getKeyString() {
        StringBuilder SB = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            SB.append(this.keyPanel.getKey(i));
        }
        return SB.toString();
    }

    public void setKey(String key) {
        if (key.length() != 40) {
            throw new IllegalArgumentException("Key : '" + key + "' is wrong length, expected 40 , actual " + key.length());
        }
        int index = 0;
        for (int i = 0; i < 5; ++i) {
            this.keyPanel.setKey(i, key.substring(index, index += 8));
        }
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String newMacAddress) {
        String oldMacAddress = this.macAddress;
        this.macAddress = newMacAddress;
        this.firePropertyChange("macAddress", oldMacAddress, newMacAddress);
    }

    void doImportLicence() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("OrderMate License Files *.lic", "lic"));
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (SilentSecurity.readInFile(file, new RMISecurityDetails())) {
            JOptionPane.showMessageDialog(this, "Details have been updated.");
        } else {
            JOptionPane.showMessageDialog(this, "Details have not been updated, check logs for more info.");
        }
        this.importedLicense.emit();
    }

    private class LicenseKeyPanel
    extends LicenseSubPanel {
        private Font font;
        private List<JTextField> keyFields;
        private SoftwareKeyValidator validator;

        private LicenseKeyPanel() {
        }

        @Override
        void loadLicense(License license) {
        }

        public String getKey(int i) {
            return this.keyFields.get(i).getText();
        }

        public void setKey(int i, String value) {
            this.keyFields.get(i).setText(value);
        }

        @Override
        void saveLicense(License license) {
        }

        @Override
        protected void setupComponents() {
            this.setBorder(new TitledBorder("License Keys"));
            this.validator = new SoftwareKeyValidator();
            this.font = new Font("Monospaced", 0, 12);
            FieldPanelBuilder builder = new FieldPanelBuilder();
            this.keyFields = new ArrayList<JTextField>(5);
            for (int i = 0; i < 5; ++i) {
                this.addKeyField(i, builder);
            }
            this.add(builder.getPanel());
        }

        private void addKeyField(int index, FieldPanelBuilder builder) {
            JTextField field = new JTextField(10);
            field.setFont(this.font);
            this.keyFields.add(field);
            field.setName("Key " + (index + 1));
            builder.addRow(field.getName(), (Component)field);
            this.attachValidator(field, this.validator);
        }

        @Override
        Validator.Result validateGui() {
            Validator.Result result = null;
            return result;
        }
    }

    private class LicenseBodyPanel
    extends LicenseSubPanel {
        private Map<LicenseType, JComponent> compMap;

        private LicenseBodyPanel() {
        }

        @Override
        void loadLicense(License theLicense) {
            for (LicenseType type : this.compMap.keySet()) {
                this.loadValue(theLicense, type, this.compMap.get(type));
            }
        }

        private void loadValue(License theLicense, LicenseType type, JComponent comp) {
            if (comp instanceof JCheckBox) {
                ((JCheckBox)comp).setSelected(theLicense.getBoolean(type));
            } else {
                ((JSpinner)comp).setValue(theLicense.getLicenseValue(type));
            }
        }

        @Override
        void saveLicense(License theLicense) {
            for (LicenseType type : this.compMap.keySet()) {
                this.saveValue(theLicense, type, this.compMap.get(type));
            }
        }

        private void saveValue(License theLicense, LicenseType type, JComponent comp) {
            if (comp instanceof JCheckBox) {
                boolean result = ((JCheckBox)comp).isSelected();
                theLicense.setLicenseValue(type, result ? 1 : 0);
            } else {
                theLicense.setLicenseValue(type, ((Number)((JSpinner)comp).getValue()).intValue());
            }
        }

        void setEditable(boolean value) {
            this.compMap.get(LicenseType.NumWaitermateTerminals).setEnabled(value);
        }

        @Override
        protected void setupComponents() {
            JTabbedPane tab = new JTabbedPane();
            this.compMap = new HashMap<LicenseType, JComponent>();
            FieldPanelBuilder builder = new FieldPanelBuilder();
            this.addIntegerField(LicenseType.NumWaitermateTerminals, 1, builder);
            final JCheckBox chkStock = this.addBooleanField(LicenseType.StockControlEnabled, builder);
            final JCheckBox chkStockAreas = this.addBooleanField(LicenseType.StockControlMultipleAreasEnabled, builder);
            chkStock.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!chkStock.isSelected()) {
                        if (chkStockAreas.isSelected()) {
                            chkStockAreas.setSelected(false);
                        }
                        chkStockAreas.setEnabled(false);
                    }
                    if (chkStock.isSelected() && !chkStockAreas.isEnabled()) {
                        chkStockAreas.setEnabled(true);
                    }
                }
            });
            tab.add("General", builder.getPanel());
            builder = new FieldPanelBuilder();
            this.addIntegerField(LicenseType.NumHomeDelivery, 0, builder);
            this.addBooleanField(LicenseType.ReservationIntegrationEnabled, builder);
            this.addBooleanField(LicenseType.RMSIntegrationEnabled, builder);
            this.addBooleanField(LicenseType.MYOBIntegrationEnabled, builder);
            this.addBooleanField(LicenseType.MelwaysMapsEnabled, builder);
            this.addBooleanField(LicenseType.LiquorfileIntegrationEnabled, builder);
            this.addBooleanField(LicenseType.EftposIntegrationEnabled, builder);
            this.addIntegerField(LicenseType.NumTouchPrepExpress, 0, builder);
            this.addIntegerField(LicenseType.NumCustomerDisplay, 0, builder);
            this.addBooleanField(LicenseType.OnlineOrderingIntegrationEnabled, builder);
            this.addBooleanField(LicenseType.CustomerLoyaltyEnabled, builder);
            this.addBooleanField(LicenseType.CouponsIntegrationEnabled, builder);
            tab.add("Integration", builder.getPanel());
            builder = new FieldPanelBuilder();
            this.addBooleanField(LicenseType.WRCustomerSales, builder);
            this.addBooleanField(LicenseType.WRIntegratedPayment, builder);
            this.addBooleanField(LicenseType.WROnlineOrder, builder);
            this.addBooleanField(LicenseType.WRPayAtTable, builder);
            this.addBooleanField(LicenseType.WRReporting, builder);
            this.addBooleanField(LicenseType.WRSalesByTime, builder);
            this.addBooleanField(LicenseType.WRTimesheet, builder);
            this.addBooleanField(LicenseType.WRUser, builder);
            this.addBooleanField(LicenseType.WRBarTabs, builder);
            tab.add("Web Resources", builder.getPanel());
            this.add(tab);
        }

        private JComponent addIntegerField(LicenseType type, int min, FieldPanelBuilder builder) {
            JSpinner spinner = new JSpinner(new SpinnerNumberModel(min, min, Integer.MAX_VALUE, 1));
            ((JSpinner.NumberEditor)spinner.getEditor()).getTextField().setColumns(5);
            builder.addRow(type.getDescription(), (Component)spinner);
            this.compMap.put(type, spinner);
            return spinner;
        }

        private JCheckBox addBooleanField(LicenseType type, FieldPanelBuilder builder) {
            JCheckBox box = new JCheckBox();
            builder.addRow(type.getDescription(), (Component)box);
            this.compMap.put(type, box);
            return box;
        }

        @Override
        Validator.Result validateGui() {
            return null;
        }
    }

    private class LicenseHeaderPanel
    extends LicenseSubPanel {
        private JTextField macAddressField;
        private JTextField abnField;
        private JButton importLicense;
        private Validator macAddressValidator;
        private boolean editable;

        LicenseHeaderPanel() {
            this.editable = false;
        }

        void setEditable(boolean value) {
            this.editable = value;
            this.macAddressField.setEditable(value);
            this.abnField.setEditable(value);
        }

        @Override
        protected void setupComponents() {
            FieldPanelBuilder builder = new FieldPanelBuilder();
            this.importLicense = new JButton("Import License...");
            this.importLicense.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == LicenseHeaderPanel.this.importLicense) {
                        LicensePanel.this.doImportLicence();
                    }
                }
            });
            final Pattern macPattern = Pattern.compile("[0-9a-fA-F]{12}");
            this.macAddressField = new JTextField(12);
            this.macAddressValidator = new Validator(){

                public Validator.Result validate(Object arg0) {
                    Matcher matcher = macPattern.matcher((String)arg0);
                    if (!matcher.matches()) {
                        return new Validator.Result((Validator)this, arg0, "Doesn't match an hexadecimal 12 character MAC address.");
                    }
                    return null;
                }
            };
            this.attachValidator(this.macAddressField, this.macAddressValidator);
            this.abnField = new JTextField(12);
            this.attachValidator(this.abnField, (Validator)new NotEmptyValidator());
            builder.addRow("", (Component)this.importLicense);
            builder.addRow("MAC Address :", (Component)this.macAddressField);
            builder.addRow("Customer Business Number :", (Component)this.abnField);
            this.add(builder.getPanel());
        }

        @Override
        void loadLicense(License theLicense) {
            this.macAddressField.setText(LicensePanel.this.macAddress);
            this.abnField.setText(theLicense.getAbn());
        }

        @Override
        void saveLicense(License theLicense) {
            if (this.editable) {
                LicensePanel.this.macAddress = this.macAddressField.getText();
                theLicense.setAbn(this.abnField.getText());
            }
        }

        @Override
        Validator.Result validateGui() {
            Validator.Result result = this.macAddressValidator.validate((Object)this.macAddressField.getText());
            if (result == null) {
                result = new NotEmptyValidator().validate((Object)this.abnField.getText());
            }
            return result;
        }
    }

    private abstract class LicenseSubPanel
    extends JPanel {
        LicenseSubPanel() {
            super(new BorderLayout());
            this.setupComponents();
        }

        protected abstract void setupComponents();

        abstract void loadLicense(License var1);

        abstract void saveLicense(License var1);

        abstract Validator.Result validateGui();

        protected void attachValidator(final JTextField field, final Validator validator) {
            field.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.checkForValid();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.checkForValid();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.checkForValid();
                }

                private void checkForValid() {
                    final Validator.Result result = validator.validate((Object)field.getText());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (result != null) {
                                field.setToolTipText(result.getDescription());
                                field.setBackground(Color.YELLOW);
                            } else {
                                field.setToolTipText("");
                                field.setBackground(Color.WHITE);
                            }
                        }
                    });
                }
            });
        }
    }
}

