/*
 * Decompiled with CFR 0.152.
 */
package servermate.gui.license;

import au.com.ordermate.persistence.SaveContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.license.License;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.users.User;
import ordermate.security.impl.SecurityDetails;
import servermate.client.ServerMateClient;
import servermate.events.LicenseSuccessHandler;
import servermate.gui.ServerMateFrame;
import servermate.gui.license.LicensePanel;

public class ServermateLicenseDialog
extends JDialog
implements ActionListener {
    private JButton okButton = new JButton("Ok");
    private JButton cancelButton = new JButton("Cancel");
    private boolean okPressed = false;
    private LicensePanel licensePanel;
    private final SecurityDetails details;
    private static ServermateLicenseDialog instance;

    public static ServermateLicenseDialog getLicenseDialog(SecurityDetails details) {
        ServerMateClient.LOG.info("ServermateLicenseDialog : " + details);
        if (instance == null) {
            JFrame frame = ServerMateFrame.getFrame();
            instance = new ServermateLicenseDialog((Frame)frame, new LicensePanel((License)PersistentLicenseManager.getInstance(), false), details);
            instance.updateDialog();
        }
        return instance;
    }

    public static void doLicenseDialog(SecurityDetails details) {
        ServermateLicenseDialog licenseDialog = null;
        String possibleCause = "Please check Servermate IP Address is set correctly using Datamate";
        try {
            licenseDialog = ServermateLicenseDialog.getLicenseDialog(details);
        }
        catch (NullPointerException ex) {
            ServerMateClient.LOG.error(ex.getMessage(), (Throwable)ex);
            possibleCause = "Please check Servermate IP Address is set correctly using Datamate";
        }
        catch (ExceptionInInitializerError ex) {
            ServerMateClient.LOG.error(ex.getMessage(), (Throwable)ex);
            possibleCause = "Please check Servermate IP Address is set correctly using Datamate";
        }
        catch (NoClassDefFoundError ncde) {
            ServerMateClient.LOG.error(ncde.getMessage(), (Throwable)ncde);
            possibleCause = "Please check Servermate IP Address: If it is correct, please restart Servermate Client";
        }
        if (licenseDialog == null) {
            JOptionPane.showMessageDialog(ServerMateFrame.getFrame(), possibleCause);
            return;
        }
        licenseDialog.updateDialog();
        licenseDialog.displayDialog();
        if (licenseDialog.getOKPressed()) {
            PersistentLicenseManager license = (PersistentLicenseManager)licenseDialog.getLicensePanel().saveLicense();
            license.save();
            String macAddress = licenseDialog.getMacAddress();
            String keyString = licenseDialog.getLicensePanel().getKeyString();
            boolean updateDongle = true;
            if (keyString.trim().isEmpty()) {
                keyString = details.getLicenseHash();
                updateDongle = false;
            }
            if (license.isValid(keyString, macAddress)) {
                PersistentLicenseManager persistentLicense = PersistentLicenseManager.getInstance();
                persistentLicense.copy(licenseDialog.getLicensePanel().saveLicense(), keyString, macAddress);
                persistentLicense.prepareForSave((SaveContext)new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser()));
                persistentLicense.save();
                new LicenseSuccessHandler();
                if (updateDongle) {
                    ServerMateClient.LOG.debug("doLicenseDialog  :: setLicenseHash");
                    details.setLicenseHash(keyString);
                }
            } else {
                ServerMateClient.LOG.debug("doLicenseDialog  :: license is invalid ");
                licenseDialog.setVisible(false);
                JOptionPane.showMessageDialog(licenseDialog, "Key was not valid, license has not been updated.");
                ServermateLicenseDialog.doLicenseDialog(details);
            }
        }
    }

    private void updateDialog() {
        String macAddress = this.details.getRecordedMacAddress();
        PersistentLicenseManager license = PersistentLicenseManager.getInstance();
        ServerMateClient.LOG.debug("updatedialog ;; details : license " + license.getAllLicenses());
        license.copy((License)PersistentLicenseManager.getInstance(), PersistentLicenseManager.getInstance().generateLicenseKey(macAddress), macAddress);
        license.setLicenseValue(LicenseType.NumWaitermateTerminals, this.details.getNumWaitermateTerminals());
        this.getLicensePanel().setLicense((License)license);
        this.getLicensePanel().setMacAddress(macAddress);
    }

    private String getMacAddress() {
        return this.details.getRecordedMacAddress();
    }

    private ServermateLicenseDialog(Frame parent, LicensePanel panel, SecurityDetails secDetails) {
        super(parent);
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        }
        this.details = secDetails;
        this.setTitle("Software License");
        this.setDefaultCloseOperation(1);
        this.setIconImage(ServerMateFrame.ORDERMATE_ICON.getImage());
        this.setModal(true);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel buttonPane = new JPanel(new BorderLayout());
        buttonPane.add((Component)this.okButton, "West");
        buttonPane.add((Component)this.cancelButton, "East");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "North");
        this.getContentPane().add((Component)buttonPane, "South");
        this.licensePanel = panel;
        this.licensePanel.importedLicense.connect((Object)this, "importedLicense");
        this.pack();
    }

    public boolean getOKPressed() {
        return this.okPressed;
    }

    public void displayDialog() {
        this.okPressed = false;
        this.pack();
        this.setVisible(true);
    }

    void importedLicense() {
        this.updateDialog();
    }

    public LicensePanel getLicensePanel() {
        return this.licensePanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            int response = JOptionPane.showConfirmDialog(this, "Are you sure you want to update the software license", "Update License?", 2, 3);
            if (response == 0) {
                this.okPressed = true;
                this.setVisible(false);
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }
}

