/*
 * Decompiled with CFR 0.152.
 */
package servermate.gui.redback;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.ClientResponse;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingWorker;
import ordermate.integration.controlcenter.ControlCenterRequest;

public class RedbackIdWorker
extends SwingWorker<Map<String, String>, String> {
    private final Long storeId;
    private String errorMessage;

    public RedbackIdWorker(Long storeId) {
        this.storeId = storeId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private boolean isSuccessResponse(ClientResponse response) {
        return response.getStatus() / 100 == 2;
    }

    @Override
    protected Map<String, String> doInBackground() throws Exception {
        ControlCenterRequest request = new ControlCenterRequest();
        ClientResponse response = request.getStoreDetails(this.storeId);
        if (this.isSuccessResponse(response)) {
            InputStreamReader reader = new InputStreamReader(response.getEntityInputStream());
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
            return (Map)objectMapper.readValue((Reader)reader, HashMap.class);
        }
        this.errorMessage = (String)response.getEntity(String.class);
        return null;
    }
}

