/*
 * Decompiled with CFR 0.152.
 */
package servermate.gui.synchronisation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.Future;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import ordermate.hom.synchronisation.SyncQueueVendor;
import ordermate.hom.synchronisation.SynchronisationModel;
import ordermate.hom.synchronisation.Synchroniser;
import ordermate.maps.DependenciesUtil;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import servermate.ServerMate;
import servermate.gui.synchronisation.SynchronisationTableModel;

public class SynchronisationDialog
extends JDialog {
    private final Signal endSignal;
    private JScrollPane jScrollPane1;
    private JProgressBar progressBar;
    private JButton stopButton;
    private JTable table;
    private static Future syncFuture;

    public SynchronisationDialog(Frame parent, boolean modal, Signal end) {
        super(parent, modal);
        this.initComponents();
        this.endSignal = end != null ? end : Signals.createSignal();
        this.endSignal.connect((Object)this, "gotEnd");
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.stopButton = new JButton();
        this.progressBar = new JProgressBar();
        this.setDefaultCloseOperation(2);
        this.setTitle("Synchronisation");
        this.table.setModel(new SynchronisationTableModel());
        this.jScrollPane1.setViewportView(this.table);
        this.stopButton.setText("Stop");
        this.stopButton.setToolTipText("Stop the current synchronisation");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynchronisationDialog.this.stopButtonActionPerformed(evt);
            }
        });
        JPanel titlePanel = new JPanel();
        titlePanel.add(new JLabel("<HTML><H2>Synchronising data to Business Central.</H2><BR>ServerMate is performing an initial synchronisation of its database with business central, <BR> this could take some time and you will be unable to use the system whilst this is running.</HTML>"));
        JPanel tablePanel = new JPanel();
        GroupLayout layout = new GroupLayout(tablePanel);
        tablePanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.progressBar, -1, 300, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.stopButton)).addComponent(this.jScrollPane1, -1, 375, Short.MAX_VALUE)).addGap(15, 15, 15)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 275, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.stopButton).addComponent(this.progressBar, -2, -1, -2)).addContainerGap()));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)titlePanel, "North");
        this.getContentPane().add((Component)tablePanel, "Center");
        this.pack();
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        SynchronisationDialog.stop();
    }

    public static void start(JFrame parent) {
        SynchronisationDialog.start(parent, Signals.createSignal());
    }

    public static void start(final JFrame parent, final Signal endSignal) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SynchronisationDialog dialog = new SynchronisationDialog((Frame)parent, true, endSignal);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        SynchronisationDialog.stop();
                    }
                });
                dialog.launchSynchroniseHo();
                dialog.setVisible(true);
            }
        });
    }

    public static void stop() {
        if (syncFuture != null) {
            syncFuture.cancel(true);
        }
    }

    private void launchSynchroniseHo() {
        if (syncFuture != null && !syncFuture.isDone()) {
            syncFuture.cancel(true);
        }
        this.stopButton.setEnabled(true);
        this.progressBar.setIndeterminate(true);
        Synchroniser sync = new Synchroniser(SyncQueueVendor.getQueue((SyncQueueVendor.SyncQueueType)SyncQueueVendor.SyncQueueType.HeadOfficeUpdate).getSnapshotBuffer(), DependenciesUtil.getEntitiesByDependency(), this.endSignal);
        SynchronisationModel model = (SynchronisationModel)this.table.getModel();
        model.clear();
        sync.setModel(model);
        try {
            syncFuture = sync.synchroniseAll();
        }
        catch (Throwable ex) {
            ServerMate.LOG.warn((Object)ex);
        }
    }

    public void gotEnd() {
        this.stopButton.setEnabled(false);
        this.progressBar.setIndeterminate(false);
        this.setVisible(false);
    }
}

