/*
 * Decompiled with CFR 0.152.
 */
package servermate.gui.synchronisation;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import ordermate.hom.synchronisation.SynchronisationModel;
import servermate.gui.synchronisation.SynchronisedTable;

public class SynchronisationTableModel
extends AbstractTableModel
implements SynchronisationModel {
    private List<SynchronisedTable> rows = new ArrayList<SynchronisedTable>();

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Name";
        }
        if (column == 1) {
            return "Count";
        }
        return "Total rows";
    }

    @Override
    public int findColumn(String columnName) {
        if (columnName.equals("Name")) {
            return 0;
        }
        if (columnName.equals("Count")) {
            return 1;
        }
        return 2;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.rows.get(rowIndex).getName();
        }
        if (columnIndex == 1) {
            return this.rows.get(rowIndex).getCount();
        }
        return this.rows.get(rowIndex).getTotal();
    }

    public void addTable(String name) {
        this.rows.add(new SynchronisedTable(name));
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void updateCount(int count) {
        this.rows.get(this.rows.size() - 1).setCount(count);
        this.fireTableRowsUpdated(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void updateTotal(int total) {
        this.rows.get(this.rows.size() - 1).setTotal(total);
        this.fireTableRowsUpdated(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void clear() {
        this.rows.clear();
        this.fireTableDataChanged();
    }
}

