/*
 * Decompiled with CFR 0.152.
 */
package servermate.integrity;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.users.User;

public class DeliveryAccountCustomerCheck {
    private static final String MISSING_CUSTOMER = "MISSING CUSTOMER";

    public void check() {
        List<Account> allAccountToFix = this.getAllAccountsWithNullCustomer();
        if (!allAccountToFix.isEmpty()) {
            Customer missingCustomer = this.getMissingCustomer();
            User systemUser = User.getSystemUser();
            EventContext context = new EventContext(systemUser);
            for (Account acc : allAccountToFix) {
                OrderMate.LOG.warn("The Delivery Account " + acc + " has a null Customer reference, replacing with Missing Customer.");
                acc.lock(systemUser);
                acc.setCustomer(missingCustomer, context);
                acc.save();
                acc.unlock();
            }
        }
    }

    private List<Account> getAllAccountsWithNullCustomer() {
        return PersistenceManager.getObjectList(Account.class, (String)Query.select(Account.class).equals(Account.Properties.ACCOUNT_TYPE, (Object)AccountType.deliveryType).isNull(Account.Properties.CUSTOMER).toString());
    }

    private Customer getMissingCustomer() {
        ObjectQuery qry = Query.select(Customer.class).equals(Customer.Properties.FIRST_NAME, (Object)MISSING_CUSTOMER);
        Customer customer = (Customer)PersistenceManager.getObject(Customer.class, (String)qry.toString(), null);
        if (customer == null) {
            customer = new Customer();
            customer.setFirstName(MISSING_CUSTOMER);
            customer.setLastName("created by " + this.getClass().getSimpleName());
            customer.delete();
            customer = (Customer)PersistenceManager.reacquire((PersistentObjectI)customer);
        }
        return customer;
    }
}

