/*
 * Decompiled with CFR 0.152.
 */
package servermate.integrity;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import ordermate.database.finance.priceadjustment.inventory.DeliveryPriceAdjustment;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.AccountTypeTrigger;
import ordermate.database.sales.AccountType;
import servermate.ServerMate;

public class DeliveryTriggerCheck {
    private AccountTypeTrigger trigger;

    public void check() {
        if (AccountTypeTrigger.findDeliveryAccTypeTrigger() == null) {
            ServerMate.LOG.warn("The DELIVERY trigger is missing, creating it.");
            this.trigger = new AccountTypeTrigger(AccountType.deliveryType);
            this.trigger.setLabel("Delivery Account Type Trigger");
            this.trigger.save();
            this.checkHistory();
        }
    }

    private void checkHistory() {
        assert (this.trigger != null);
        int fixed = 0;
        ObjectQuery qry = Query.select(DeliveryPriceAdjustment.class).active(DeliveryPriceAdjustment.class);
        List allAdj = PersistenceManager.getObjectList(DeliveryPriceAdjustment.class, (String)qry.toString());
        for (DeliveryPriceAdjustment adj : allAdj) {
            if (adj.getTriggers().size() != 0) continue;
            adj.addTrigger((AbstractTrigger)this.trigger);
            adj.save();
            ++fixed;
        }
        if (fixed > 0) {
            ServerMate.LOG.warn(fixed + " missing link(s) fixed for " + allAdj.size() + " delivery price adjustment(s)");
        }
    }
}

