/*
 * Decompiled with CFR 0.152.
 */
package servermate.integrity;

import au.com.ordermate.guicore.task.TaskInterrupter;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.ClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.PropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ReferenceMapping;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.InventoryItemUnitBarcodeLink;
import ordermate.database.finance.Shift;
import ordermate.database.finance.priceadjustment.PriceAdjustmentTriggerLink;
import ordermate.database.finance.priceadjustment.SalesItemPriceAdjustmentLink;
import ordermate.database.finance.reconciliation.AbstractReconciliationEntry;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.integration.TerminalIntegrationExtID;
import ordermate.database.integration.UserIntegrationExtID;
import ordermate.database.integration.giftvoucher.GiftVoucherConfigurationGLAccountLink;
import ordermate.database.inventory.InventoryDefaultAdd;
import ordermate.database.inventory.InventoryDefaultMod;
import ordermate.database.inventory.InventoryDefaultOption;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.InventorySpecial;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.triggers.TradingDayTrigger;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.CustomerPoints;
import ordermate.database.sales.SalesComponentTax;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.coupon.SalesCouponUsage;
import ordermate.database.stock.StockItemParLevel;
import ordermate.database.stock.StockTakeEntry;
import ordermate.database.stock.usage.PersistentStockUsage;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.database.stock.usagelink.StockUsageOptionLink;
import ordermate.database.users.User;
import ordermate.maps.AllMappings;
import servermate.integrity.DeleteFix;
import servermate.integrity.FixBuilder;
import servermate.integrity.NoFix;
import servermate.integrity.UpdateFix;

public class ReferencesCheck {
    private static final String NULL = "NULL";
    private static final String MISSING_USER = "MISSING USER";
    private static final String MISSING_SHIFT = "MISSING SHIFT";
    private static final String MISSING_TERMINAL = "MISSING TERMINAL";
    private static final String MISSING_TERMINAL_LOCATION = "MISSING TERMINAL LOCATION";
    private final FixBuilder defaultFix = new UpdateFix();
    private final FixBuilder deleteFix = new DeleteFix();
    private final FixBuilder noFix = new NoFix();
    private final Map<PropertiedObject.Property, FixBuilder> rules = new HashMap<PropertiedObject.Property, FixBuilder>();
    private final PersistenceMetaData meta;
    private TaskInterrupter taskInterrupter;

    public ReferencesCheck() {
        this.rules.put(InventorySpecial.Properties.ITEM, this.deleteFix);
        this.rules.put(InventoryDefaultMod.Properties.UNIT, this.deleteFix);
        this.rules.put(InventoryDefaultAdd.Properties.ADD, this.noFix);
        this.rules.put(InventoryDefaultOption.Properties.OPTION, this.noFix);
        this.rules.put(UnitPriceLevel.Properties.UNIT, this.deleteFix);
        this.rules.put(InventoryOptionGroupLink.Properties.ITEM_UNIT, this.deleteFix);
        this.rules.put(InventoryOptionGroupLink.Properties.OPTION_GROUP, this.deleteFix);
        this.rules.put(SalesItemQuantity.Properties.SALES_LINE_ITEM, this.deleteFix);
        this.rules.put(StockInventoryUsageLink.Properties.STOCK_ITEM, this.deleteFix);
        this.rules.put(StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT, this.deleteFix);
        this.rules.put(StockUsageOptionLink.Properties.INVENTORY_OPTION, this.deleteFix);
        this.rules.put(StockUsageOptionLink.Properties.STOCK_ITEM, this.deleteFix);
        this.rules.put(CustomerPoints.Properties.CUSTOMER, this.deleteFix);
        this.rules.put(GiftVoucherConfigurationGLAccountLink.Properties.GIFT_VOUCHER_CONFIG, this.deleteFix);
        this.rules.put(PriceAdjustmentTriggerLink.Properties.TRIGGER, this.deleteFix);
        this.rules.put(PersistentStockUsage.Properties.STOCK_ITEM, this.deleteFix);
        this.rules.put(StockTakeEntry.Properties.STOCK_TAKE, this.deleteFix);
        this.rules.put(TradingDayTrigger.Properties.TRADING_DAY, this.defaultFix);
        this.rules.put(AbstractReconciliationEntry.Properties.PARENT, this.deleteFix);
        this.rules.put(CashdrawerReconciliation.Properties.PARENT, this.deleteFix);
        this.rules.put(InventoryOptionGroupLink.Properties.ITEM_UNIT, this.deleteFix);
        this.rules.put(InventoryOptionGroupLink.Properties.OPTION_GROUP, this.deleteFix);
        this.rules.put(SalesItemPriceAdjustmentLink.Properties.SALES_LINE_ITEM, this.deleteFix);
        this.rules.put(SalesItemPriceAdjustmentLink.Properties.SALES_PRICE_ADJUSTMENT, this.deleteFix);
        this.rules.put(SalesComponentTax.Properties.SALES_COMPONENT, this.deleteFix);
        this.rules.put(InventoryItemUnitBarcodeLink.Properties.ITEM_UNIT, this.deleteFix);
        this.rules.put(InventoryItemUnitBarcodeLink.Properties.BARCODE, this.deleteFix);
        this.rules.put(StockItemParLevel.Properties.STOCK_ITEM, this.deleteFix);
        this.rules.put(StockItemParLevel.Properties.STOCK_AREA, this.deleteFix);
        this.rules.put(TerminalIntegrationExtID.Properties.TERMINAL, this.noFix);
        this.rules.put(UserIntegrationExtID.Properties.USER, this.noFix);
        this.rules.put(SalesCouponUsage.Properties.ACCOUNT, this.deleteFix);
        this.meta = PersistenceManager.getPersistenceMetaData();
    }

    public ReferencesCheck(TaskInterrupter interrupter) {
        this.rules.put(InventorySpecial.Properties.ITEM, this.deleteFix);
        this.rules.put(InventoryDefaultMod.Properties.UNIT, this.deleteFix);
        this.rules.put(InventoryDefaultAdd.Properties.ADD, this.noFix);
        this.rules.put(InventoryDefaultOption.Properties.OPTION, this.noFix);
        this.rules.put(UnitPriceLevel.Properties.UNIT, this.deleteFix);
        this.rules.put(InventoryOptionGroupLink.Properties.ITEM_UNIT, this.deleteFix);
        this.rules.put(InventoryOptionGroupLink.Properties.OPTION_GROUP, this.deleteFix);
        this.rules.put(SalesItemQuantity.Properties.SALES_LINE_ITEM, this.deleteFix);
        this.rules.put(StockInventoryUsageLink.Properties.STOCK_ITEM, this.deleteFix);
        this.rules.put(StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT, this.deleteFix);
        this.rules.put(StockUsageOptionLink.Properties.INVENTORY_OPTION, this.deleteFix);
        this.rules.put(StockUsageOptionLink.Properties.STOCK_ITEM, this.deleteFix);
        this.rules.put(CustomerPoints.Properties.CUSTOMER, this.deleteFix);
        this.rules.put(GiftVoucherConfigurationGLAccountLink.Properties.GIFT_VOUCHER_CONFIG, this.deleteFix);
        this.rules.put(PriceAdjustmentTriggerLink.Properties.TRIGGER, this.deleteFix);
        this.rules.put(PersistentStockUsage.Properties.STOCK_ITEM, this.deleteFix);
        this.rules.put(StockTakeEntry.Properties.STOCK_TAKE, this.deleteFix);
        this.rules.put(TradingDayTrigger.Properties.TRADING_DAY, this.defaultFix);
        this.rules.put(AbstractReconciliationEntry.Properties.PARENT, this.deleteFix);
        this.rules.put(CashdrawerReconciliation.Properties.PARENT, this.deleteFix);
        this.rules.put(InventoryOptionGroupLink.Properties.ITEM_UNIT, this.deleteFix);
        this.rules.put(InventoryOptionGroupLink.Properties.OPTION_GROUP, this.deleteFix);
        this.rules.put(SalesItemPriceAdjustmentLink.Properties.SALES_LINE_ITEM, this.deleteFix);
        this.rules.put(SalesItemPriceAdjustmentLink.Properties.SALES_PRICE_ADJUSTMENT, this.deleteFix);
        this.rules.put(SalesComponentTax.Properties.SALES_COMPONENT, this.deleteFix);
        this.rules.put(InventoryItemUnitBarcodeLink.Properties.ITEM_UNIT, this.deleteFix);
        this.rules.put(InventoryItemUnitBarcodeLink.Properties.BARCODE, this.deleteFix);
        this.rules.put(StockItemParLevel.Properties.STOCK_ITEM, this.deleteFix);
        this.rules.put(StockItemParLevel.Properties.STOCK_AREA, this.deleteFix);
        this.rules.put(TerminalIntegrationExtID.Properties.TERMINAL, this.noFix);
        this.rules.put(UserIntegrationExtID.Properties.USER, this.noFix);
        this.rules.put(SalesCouponUsage.Properties.ACCOUNT, this.deleteFix);
        this.meta = PersistenceManager.getPersistenceMetaData();
        this.taskInterrupter = interrupter;
    }

    public void check() {
        int MAX_CHECKS = 50;
        int currentErrors = 0;
        int lastError = 0;
        int totalCount = 0;
        do {
            OrderMate.LOG.info("Performing database referential integrity check " + (totalCount + 1));
            lastError = currentErrors;
        } while ((currentErrors = this.performCheck()) != 0 && currentErrors != lastError && ++totalCount < 50);
        if (totalCount == 50) {
            OrderMate.LOG.error("Still had referential integrity problems after checking 50 times");
        } else if (currentErrors != 0) {
            OrderMate.LOG.error("Could not fix all errors, still has " + currentErrors + " errors");
        }
        OrderMate.LOG.info("Referential integrity Check complete");
    }

    protected int performCheck() {
        Collection mappings = AllMappings.getMappings();
        int errors = 0;
        for (ClassMap map : mappings) {
            if (!map.supportsQueries() || Modifier.isAbstract(map.getClass().getModifiers()) || Modifier.isAbstract(map.getTypeClass().getModifiers())) continue;
            errors += this.checkRef(map);
        }
        if (errors > 0) {
            OrderMate.LOG.warn("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            OrderMate.LOG.warn("Reference check fixed " + errors + " referential integrity errors");
            OrderMate.LOG.warn("XXXXXXXXXXXXXXXXXXXXXX=============XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        }
        return errors;
    }

    int checkRef(ClassMap map) {
        int errors = 0;
        for (PropertyMapping propMap : map.getPropertyMappings()) {
            if (!propMap.getProperty().isReference()) continue;
            ReferenceMapping refMap = (ReferenceMapping)propMap;
            try {
                List<Long> ids = this.extractErrors(refMap);
                if (ids == null || ids.size() <= 0) continue;
                this.fixForeignKey(refMap, ids);
                errors += ids.size();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return errors;
    }

    List<Long> extractErrors(ReferenceMapping refMap) {
        Object[][] errors = null;
        LinkedList<Long> ids = null;
        int LIMIT = 1000;
        int offset = 0;
        String logMsgPrefix = "Got invalid FK for " + refMap.getProperty().getName() + " in " + refMap.getProperty().getOwner() + " for ID/FK pairs: ";
        boolean loggedFirstErrors = false;
        do {
            if (this.taskInterrupter != null && this.taskInterrupter.isInterrupt()) {
                return null;
            }
            errors = this.getErrors(refMap, 1000, offset);
            offset += 1000;
            if (errors == null || errors.length <= 0) continue;
            if (!loggedFirstErrors) {
                OrderMate.LOG.warn("Found some errors " + logMsgPrefix);
                loggedFirstErrors = true;
            }
            if (ids == null) {
                ids = new LinkedList<Long>();
            }
            for (Object[] error : errors) {
                ids.add((Long)error[0]);
            }
        } while (errors != null && errors.length != 0);
        StringBuilder msg = new StringBuilder();
        if (errors != null) {
            for (Object[] error : errors) {
                msg.append(error[0]);
                msg.append("/");
                msg.append(error[1]);
                msg.append("; ");
            }
            if (errors.length > 0) {
                OrderMate.LOG.warn(logMsgPrefix + msg.toString());
            }
        }
        return ids;
    }

    private Object[][] getErrors(ReferenceMapping refMap, int limit, int offset) {
        String sql = this.constructCheckRequest(refMap, limit, offset);
        if (sql != null) {
            return PersistenceManager.getPersistenceDelegate().executeQuery(sql, null);
        }
        return null;
    }

    private String constructCheckRequest(ReferenceMapping refMap, int limit, int offset) {
        String table = this.meta.getPropertyTable(refMap.getProperty());
        if (table == null) {
            return null;
        }
        String column = this.meta.getPropertyColumn(refMap.getProperty());
        if (column == null) {
            return null;
        }
        if (refMap.isQueryReference()) {
            return null;
        }
        String foreignTable = this.meta.getClassTable(refMap.getReferenceType());
        StringBuilder builder = new StringBuilder("SELECT A.ID, A.");
        builder.append(column);
        builder.append(" FROM ");
        builder.append(table);
        builder.append(" A LEFT JOIN ");
        builder.append(foreignTable);
        builder.append(" B ON B.ID = A.");
        builder.append(column);
        builder.append(" WHERE B.ID IS NULL AND A.");
        builder.append(column);
        builder.append(" IS NOT NULL");
        builder.append(" LIMIT " + limit + " OFFSET " + offset);
        return builder.toString();
    }

    private void fixForeignKey(ReferenceMapping propMap, List<Long> ids) {
        String sql = this.constructUpdateRequest(propMap);
        if (sql.isEmpty()) {
            return;
        }
        String msg = "Running " + sql + " with :";
        StringBuilder buffer = new StringBuilder(1000);
        buffer.append(msg);
        for (int i = 0; i < ids.size(); ++i) {
            buffer.append(ids.get(i));
            buffer.append(",");
            if (i % 100 != 0 || i == 0) continue;
            OrderMate.LOG.info(buffer.toString());
            buffer = new StringBuilder(1000);
            buffer.append(msg);
        }
        if (ids.size() % 100 != 0) {
            OrderMate.LOG.info(buffer.toString());
        }
        Object[] params = new Long[1];
        Iterator<Long> iterator = ids.iterator();
        while (iterator.hasNext()) {
            Long id;
            params[0] = id = iterator.next();
            PersistenceManager.getPersistenceDelegate().executeUpdate(sql, params);
        }
    }

    private String constructUpdateRequest(ReferenceMapping propMap) {
        Long id;
        String table = this.meta.getPropertyTable(propMap.getProperty());
        String column = this.meta.getPropertyColumn(propMap.getProperty());
        FixBuilder fix = null;
        String replacement = NULL;
        if (this.rules.containsKey(propMap.getProperty())) {
            fix = this.rules.get(propMap.getProperty());
        } else if (User.class.isAssignableFrom(propMap.getReferenceType())) {
            replacement = this.getMissingUserID().toString();
        } else if (TradingDay.class.isAssignableFrom(propMap.getReferenceType())) {
            Long missingTradingDayId = this.getMissingTradingDayID();
            if (missingTradingDayId != null) {
                replacement = this.getMissingTradingDayID().toString();
            }
        } else if (Shift.class.isAssignableFrom(propMap.getReferenceType())) {
            Long missingShiftId = this.getMissingShiftID();
            if (missingShiftId != null) {
                replacement = this.getMissingShiftID().toString();
            }
        } else if (Terminal.class.isAssignableFrom(propMap.getReferenceType())) {
            Long id2 = this.getMissingTerminalID();
            if (id2 != null) {
                replacement = id2.toString();
            }
        } else if (TerminalLocation.class.isAssignableFrom(propMap.getReferenceType()) && (id = this.getMissingTerminalLocationID()) != null) {
            replacement = id.toString();
        }
        if (fix == null) {
            fix = this.defaultFix;
        }
        return fix.build(table, column, replacement);
    }

    private Long getMissingTerminalID() {
        ObjectQuery qry = Query.select(Terminal.class).equals(Terminal.Properties.LABEL, (Object)MISSING_TERMINAL);
        Terminal terminal = (Terminal)PersistenceManager.getObject(Terminal.class, (String)qry.toString(), null);
        if (terminal == null) {
            try {
                terminal = new Terminal(InetAddress.getLocalHost(), "Integration");
                terminal.setLabel(MISSING_TERMINAL);
                terminal.setSystemState("DELETED");
            }
            catch (UnknownHostException e) {
                OrderMate.LOG.error("Cannot obatin the local host", (Throwable)e);
                return null;
            }
            terminal.save();
        }
        return terminal.getID();
    }

    private Long getMissingTerminalLocationID() {
        ObjectQuery qry = Query.select(TerminalLocation.class).equals(TerminalLocation.Properties.LABEL, (Object)MISSING_TERMINAL_LOCATION);
        TerminalLocation terminalLocation = (TerminalLocation)PersistenceManager.getObject(TerminalLocation.class, (String)qry.toString());
        try {
            if (terminalLocation == null) {
                terminalLocation = new TerminalLocation();
                terminalLocation.setLabel(MISSING_TERMINAL_LOCATION);
                terminalLocation.setSystemState("DELETED");
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error("Cannot create the missing terminal location", (Throwable)e);
            return null;
        }
        terminalLocation.save();
        return terminalLocation.getID();
    }

    private Long getMissingShiftID() {
        Long dayId = this.getMissingTradingDayID();
        if (dayId != null) {
            ObjectQuery qry = Query.select(Shift.class).equals(Shift.Properties.NAME, (Object)MISSING_SHIFT);
            Shift shift = (Shift)PersistenceManager.getObject(Shift.class, (String)qry.toString(), null);
            if (shift == null) {
                shift = this.createMissingShift(dayId);
            }
            return shift.getID();
        }
        return null;
    }

    private Shift createMissingShift(long dayId) {
        TradingDay day = (TradingDay)PersistenceManager.getByID((long)dayId, TradingDay.class);
        String shiftName = Shift.getShiftNames()[0];
        Shift missingShift = Shift.createShift((TradingDay)day, (ConfigShift)ConfigShift.getConfigShiftWithName((String)shiftName), (String)MISSING_SHIFT);
        missingShift.save();
        return missingShift;
    }

    private Long getMissingTradingDayID() {
        Calendar cal = Calendar.getInstance();
        cal.set(2000, 0, 1);
        ObjectQuery qry = Query.select(TradingDay.class).equals(TradingDay.Properties.CLOSE_DATE, cal.getTime(), SQLDateType.DATE);
        TradingDay day = (TradingDay)PersistenceManager.getObject(TradingDay.class, (String)qry.toString(), null);
        qry = Query.select(TradingDay.class).equals(TradingDay.Properties.ID, -1.0);
        if (day == null && (day = (TradingDay)PersistenceManager.getObject(TradingDay.class, (String)qry.toString())) == null) {
            day = new TradingDay();
            day.setDate(cal.getTime());
            day.setTime(cal.getTime());
            day.setCloseDate(cal.getTime());
            day.setCloseTime(cal.getTime());
            day.save();
        }
        PersistenceManager.getPersistenceDelegate().executeUpdate("UPDATE finance_trading_day SET ID = -1 WHERE ID = ?", new Object[]{day.getID()});
        day = (TradingDay)PersistenceManager.getObject(TradingDay.class, (String)qry.toString());
        return day.getID();
    }

    private Long getMissingUserID() {
        ObjectQuery qry = Query.select(User.class).equals(User.Properties.FIRST_NAME, (Object)MISSING_USER);
        User user = (User)PersistenceManager.getObject(User.class, (String)qry.toString(), null);
        if (user == null) {
            user = new User();
            user.setActive(false);
            user.setFirstName(MISSING_USER);
            user.setLastName("created by " + this.getClass().getSimpleName());
            user.save();
        }
        return user.getID();
    }
}

