/*
 * Decompiled with CFR 0.152.
 */
package servermate.menuimport;

import au.com.bytecode.opencsv.CSVReader;
import au.com.ordermate.configuration.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TimerTask;
import ordermate.database.EventContext;
import ordermate.database.integration.IntegrationConfiguration;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.ServermateEventLog;
import ordermate.database.users.User;
import ordermate.integration.csv.CsvMenuImportTask;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import servermate.ServerMate;

public class AutoMenuImporter
extends TimerTask {
    public static final String DESTINATION_FOLDER = "./download";
    private String server;
    private String folder;
    private String username;
    private String password;
    private long start;
    private long lastModified = 0L;

    @Override
    public void run() {
        File dest = new File(DESTINATION_FOLDER);
        if (!dest.exists() && !dest.mkdirs()) {
            throw new IllegalStateException("Cannot create the work folder ./download, the menu importer won't be able to download any data.");
        }
        this.server = BusinessInfo.getInstance().getMenuImportFtpServer();
        this.folder = BusinessInfo.getInstance().getMenuImportFtpFolder();
        this.username = Config.decryptString((String)BusinessInfo.getInstance().getMenuImportFtpUser());
        this.password = Config.decryptString((String)BusinessInfo.getInstance().getMenuImportFtpPassword());
        this.start = IntegrationConfiguration.getInstance().getLastMenuImportTime();
        File[] toProcess = this.getNewFiles();
        this.processNewFiles(toProcess);
        if (this.lastModified > this.start) {
            IntegrationConfiguration.getInstance().setLastMenuImportTime(this.lastModified);
            IntegrationConfiguration.getInstance().save();
        }
        ServerMate.LOG.info("Auto menu import is done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File[] getNewFiles() {
        File[] retValue = null;
        ArrayList<File> retFiles = new ArrayList<File>();
        FTPClient ftp = null;
        try {
            ftp = new FTPClient();
            ftp.connect(this.server);
            if (!ftp.login(this.username, this.password)) {
                ServerMate.LOG.info("Could not login to " + this.server + ".");
                File[] fileArray = retValue;
                return fileArray;
            }
            ServerMate.LOG.info("Connected to " + this.server + ".");
            ServerMate.LOG.info(ftp.getReplyString());
            if (!ftp.changeWorkingDirectory(this.folder)) {
                ServerMate.LOG.info("Could not change to directory " + this.folder + ".");
                File[] fileArray = retValue;
                return fileArray;
            }
            FTPFile[] files = ftp.listFiles();
            ServerMate.LOG.info("Number of files in dir: " + files.length);
            for (int i = 0; i < files.length; ++i) {
                long fileDate = files[i].getTimestamp().getTimeInMillis();
                if (fileDate <= this.start) continue;
                ServerMate.LOG.info("Downloading " + files[i].getName());
                File file = new File(DESTINATION_FOLDER + File.separator + files[i].getName());
                FileOutputStream fos = new FileOutputStream(file);
                if (!ftp.retrieveFile(files[i].getName(), (OutputStream)fos)) {
                    ServerMate.LOG.info("Could not retrieve file " + files[i].getName() + ".");
                }
                fos.close();
                if (!file.setLastModified(fileDate)) {
                    ServerMate.LOG.error("Failed to set the processed file date, it may be processed again and again, that's bad.");
                }
                retFiles.add(file);
            }
            retValue = retFiles.toArray(new File[retFiles.size()]);
        }
        catch (Exception e) {
            ServerMate.LOG.info("Cannot retrieve the menu updates files from " + this.server + ".", (Throwable)e);
        }
        finally {
            if (ftp != null && ftp.isConnected()) {
                try {
                    ftp.logout();
                    ftp.disconnect();
                }
                catch (IOException ex) {
                    ServerMate.LOG.info("Error disconnecting the FTP server.", (Throwable)ex);
                }
            }
        }
        return retValue;
    }

    private void processNewFiles(File[] toProcess) {
        if (toProcess == null) {
            return;
        }
        EventContext context = new EventContext(User.getSystemUser());
        Arrays.sort(toProcess, new FileDateComp());
        for (int i = 0; i < toProcess.length; ++i) {
            File file = toProcess[i];
            ServerMate.LOG.info("Will process " + file);
            try {
                List csvData = null;
                CSVReader reader = new CSVReader((Reader)new InputStreamReader(new FileInputStream(file)));
                csvData = reader.readAll();
                CsvMenuImportTask importer = new CsvMenuImportTask(csvData);
                importer.runLocal();
                this.lastModified = file.lastModified();
                ServermateEventLog.getInst().logAutoMenuImport(context, file.getName(), null);
                continue;
            }
            catch (Exception ex) {
                ServerMate.LOG.warn("Failed to process " + file + ".", (Throwable)ex);
                ServermateEventLog.getInst().logAutoMenuImport(context, file.getName(), ex.getLocalizedMessage());
            }
        }
    }

    static class FileDateComp
    implements Comparator<File> {
        FileDateComp() {
        }

        @Override
        public int compare(File o1, File o2) {
            File f1 = o1;
            File f2 = o2;
            return f1.lastModified() < f2.lastModified() ? -1 : (f1.lastModified() == f2.lastModified() ? 0 : 1);
        }
    }
}

