/*
 * Decompiled with CFR 0.152.
 */
package servermate.message;

import au.com.ordermate.message.Email;
import au.com.ordermate.message.MessageServer;
import au.com.ordermate.message.SMS;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import ordermate.database.Data;
import ordermate.database.message.Command;
import ordermate.database.message.SmsProvider;
import servermate.message.MessageReceiver;
import servermate.message.RequestHandler;

public abstract class AbstractRequestHandler
implements RequestHandler {
    protected final Command command;

    protected AbstractRequestHandler(Command cmd) {
        if (cmd == null) {
            String s = "command cannot be null!";
            throw new IllegalArgumentException(s);
        }
        this.command = cmd;
    }

    public final Command getCommand() {
        return this.command;
    }

    @Override
    public void handleReplyRequest(Email email) {
        SmsProvider provider = SmsProvider.getProvider();
        InternetAddress[] senders = email.getSenders();
        String address = senders[0].getAddress();
        if (address.endsWith(provider.getEmailSuffix())) {
            this.handleSmsRequest(email);
        } else {
            this.handleEmailRequest(email);
        }
    }

    protected void handleSmsRequest(Email email) {
        String address = email.getSenders()[0].getAddress();
        String phoneNumber = address.substring(2, address.indexOf(64));
        phoneNumber = "0" + phoneNumber;
        String s = "Received SMS request for " + this.getCommand().getCommand() + " for mobile " + phoneNumber;
        MessageReceiver.COMMAND_LOG.info((Object)s);
        if (!this.phoneCanRequestCommand(phoneNumber, this.getCommand())) {
            s = phoneNumber + " requested sales but does not have permission to do so.";
            MessageReceiver.COMMAND_LOG.info((Object)s);
            return;
        }
        SMS sms = new SMS();
        sms.setPhoneNumber(phoneNumber);
        sms.setText(this.getResponse());
        if (!this.send(sms)) {
            s = "Attempt to send sales to " + phoneNumber + " failed.";
            MessageReceiver.COMMAND_LOG.info((Object)s);
        }
    }

    protected void handleEmailRequest(Email email) {
        int i;
        InternetAddress[] addresses = email.getSenders();
        String emailAddress = addresses[0].getAddress();
        if (!this.emailCanRequestCommand(emailAddress, this.getCommand())) {
            String s = emailAddress + " requested sales but does not have permission to do so.";
            MessageReceiver.COMMAND_LOG.info((Object)s);
            return;
        }
        Email returnEmail = new Email();
        addresses = email.getToRecipients();
        if (addresses != null) {
            for (i = 0; i < addresses.length; ++i) {
                returnEmail.addSender(addresses[i]);
            }
        }
        if ((addresses = email.getSenders()) != null) {
            for (i = 0; i < addresses.length; ++i) {
                returnEmail.addToRecipient(addresses[i]);
            }
        }
        returnEmail.setSubject("OrderMate Reply");
        returnEmail.setText(this.getResponse());
        if (!this.send(returnEmail)) {
            String s = "Attempt to send sales to " + emailAddress + " failed.";
            MessageReceiver.COMMAND_LOG.info((Object)s);
        }
    }

    protected final boolean send(SMS sms) {
        boolean success;
        MessageServer server = MessageServer.getServer();
        Session session = server.getSession();
        SmsProvider provider = SmsProvider.getProvider();
        if (provider != null && provider.getProviderType().equals((Object)SmsProvider.SMSProviderType.Email)) {
            if (!sms.isSetup()) {
                SMS.setup((String)provider.getEmailSuffix(), (String)provider.getSubject(), (String)provider.getSenderEmail(), (String)provider.getSenderName());
            }
            Message message = sms.createMessage(session);
            success = server.send(message);
        } else {
            success = provider != null && provider.getProviderType().equals((Object)SmsProvider.SMSProviderType.HTTP) ? sms.sendSMSviaHTTP(false) : false;
        }
        if (success) {
            sms.logSend();
            this.logResponse(sms.getPhoneNumber(), this.getCommand());
        }
        return success;
    }

    protected final boolean send(Email email) {
        Session session;
        Message message;
        MessageServer server = MessageServer.getServer();
        boolean success = server.send(message = email.createMessage(session = server.getSession()));
        if (success) {
            this.logResponse(email.getToRecipients()[0].getAddress(), this.getCommand());
        }
        return success;
    }

    protected final boolean phoneCanRequestCommand(String phone, Command cmd) {
        List permissions = new ArrayList();
        try {
            permissions = Data.database.getPhonePermissions(cmd.getName());
        }
        catch (RemoteException e) {
            Data.handleException((RemoteException)e);
        }
        return this.searchImpl(permissions.iterator(), phone);
    }

    protected final boolean emailCanRequestCommand(String email, Command cmd) {
        List permissions = new ArrayList();
        try {
            permissions = Data.database.getEmailPermissions(cmd.getName());
        }
        catch (RemoteException e) {
            Data.handleException((RemoteException)e);
        }
        return this.searchImpl(permissions.iterator(), email);
    }

    private boolean searchImpl(Iterator iterator, String target) {
        boolean match = false;
        while (iterator.hasNext() && !match) {
            String string = (String)iterator.next();
            if (string == null || !string.trim().equals("*") && !string.trim().equalsIgnoreCase(target)) continue;
            match = true;
        }
        return match;
    }

    protected final void logResponse(String destination, Command cmd) {
        String timestamp = "";
        Calendar cal = Calendar.getInstance();
        timestamp = timestamp + this.pad(cal.get(1));
        timestamp = timestamp + this.pad(cal.get(2) + 1);
        timestamp = timestamp + this.pad(cal.get(5));
        timestamp = timestamp + this.pad(cal.get(11));
        timestamp = timestamp + this.pad(cal.get(12));
        timestamp = timestamp + this.pad(cal.get(13));
        try {
            Data.database.logCommandResponse(destination, timestamp, cmd.getID().intValue());
        }
        catch (RemoteException e) {
            Data.handleException((RemoteException)e);
        }
    }

    private String pad(int i) {
        if (i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }
}

