/*
 * Decompiled with CFR 0.152.
 */
package servermate.message;

import au.com.ordermate.message.Email;
import ordermate.database.message.Command;
import servermate.message.MessageReceiver;
import servermate.message.RequestHandler;
import servermate.message.TakingsHandler;

public class CommandDispatcher {
    private static CommandDispatcher dispatcher;
    private RequestHandler takingsHandler = new TakingsHandler();

    private CommandDispatcher() {
    }

    public void dispatchReplyRequest(String command, Email email) {
        Command cmd = Command.getCommandByCommand((String)command);
        if (cmd != null) {
            this.dispatchReplyRequest(cmd, email);
        } else {
            MessageReceiver.COMMAND_LOG.error((Object)"Could not find a valid command in email body!");
        }
    }

    public void dispatchReplyRequest(Command command, Email email) {
        this.getHandler(command).handleReplyRequest(email);
    }

    public String dispatchResponseRequest(String command) {
        Command cmd = Command.getCommandByCommand((String)command);
        if (cmd != null) {
            return this.dispatchResponseRequest(cmd);
        }
        return null;
    }

    public String dispatchResponseRequest(Command command) {
        return this.getHandler(command).getResponse();
    }

    private RequestHandler getHandler(Command command) {
        if (command == null) {
            String s = "command cannot be null!";
            throw new IllegalArgumentException(s);
        }
        RequestHandler handler = null;
        if (command.getName().equals("SALES")) {
            handler = this.takingsHandler;
        }
        return handler;
    }

    public static CommandDispatcher getInstance() {
        if (dispatcher == null) {
            dispatcher = new CommandDispatcher();
        }
        return dispatcher;
    }
}

