/*
 * Decompiled with CFR 0.152.
 */
package servermate.message;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.database.message.ScheduledMessage;
import servermate.message.MessageTask;

public class MessageScheduler {
    private static MessageScheduler messageScheduler;
    private List tasks = new LinkedList();
    private Timer timer = new Timer();

    private MessageScheduler() {
    }

    private void load() {
        Iterator iterator = ScheduledMessage.getScheduledMessages().iterator();
        while (iterator.hasNext()) {
            MessageTask task = new MessageTask((ScheduledMessage)iterator.next());
            this.addTask(task);
        }
    }

    public void addTask(MessageTask task) {
        if (task == null) {
            String s = "task cannot be null!";
            throw new IllegalArgumentException(s);
        }
        boolean found = false;
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext() && !found) {
            MessageTask other = (MessageTask)iterator.next();
            if (task.getMessage().getID().intValue() != other.getMessage().getID().intValue()) continue;
            found = true;
        }
        if (!found) {
            this.tasks.add(task);
            Date now = new Date();
            if (task.getScheduledTime().after(now)) {
                this.timer.schedule((TimerTask)task, task.getScheduledTime());
            }
        }
    }

    public void removeTask(MessageTask task) {
        if (task == null) {
            String s = "task cannot be null!";
            throw new IllegalArgumentException(s);
        }
        boolean found = false;
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext() && !found) {
            MessageTask other = (MessageTask)iterator.next();
            if (task.getMessage().getID().intValue() != other.getMessage().getID().intValue()) continue;
            found = true;
        }
        if (found) {
            this.tasks.remove(task);
            task.cancel();
        }
    }

    public Collection getTasks() {
        return this.tasks;
    }

    public static MessageScheduler getInstance() {
        if (messageScheduler == null) {
            messageScheduler = new MessageScheduler();
            messageScheduler.load();
        }
        return messageScheduler;
    }
}

