/*
 * Decompiled with CFR 0.152.
 */
package servermate.message;

import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reports.RestaurantTakingsSummary;
import ordermate.database.hardware.Terminal;
import ordermate.database.message.Command;
import ordermate.database.sales.DriveThruAccount;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.TakeawayAccount;
import servermate.message.AbstractRequestHandler;

public class TakingsHandler
extends AbstractRequestHandler {
    private String message;

    public TakingsHandler() {
        super(Command.getCommandByName((String)"SALES"));
    }

    @Override
    public String getResponse() {
        RestaurantTakingsSummary takings = RestaurantTakingsSummary.getSummary((Shift)Terminal.getLocalHost().getShift());
        takings.getCalculateTask().run();
        this.message = "";
        this.message = this.message + "TOT SALES " + takings.getAccountsTotal();
        List sections = takings.getLocationSales();
        for (int i = 0; i < sections.size(); ++i) {
            RestaurantTakingsSummary.LocationSales ls = (RestaurantTakingsSummary.LocationSales)sections.get(i);
            String name = ls.getLocationName();
            if (name.length() > 6) {
                name = name.substring(0, 5);
            }
            this.addItem(name, ls.getTotalSales());
        }
        this.addItem("Tbl", takings.getAccounts(TableAccount.TYPE, false).add(takings.getAccounts(TableAccount.TYPE, true)));
        this.addItem("Ph", takings.getAccounts(PhoneAccount.TYPE, false).add(takings.getAccounts(PhoneAccount.TYPE, true)));
        this.addItem("TA", takings.getAccounts(TakeawayAccount.TYPE, false).add(takings.getAccounts(TakeawayAccount.TYPE, true)));
        this.addItem("DT", takings.getAccounts(DriveThruAccount.TYPE, false).add(takings.getAccounts(DriveThruAccount.TYPE, true)));
        this.addItem("Dvry", takings.getAccounts(PhoneAccount.DELIVERY_TYPE, false).add(takings.getAccounts(PhoneAccount.DELIVERY_TYPE, true)));
        this.addItem("Dis", takings.getTotalDiscounts());
        this.addItem("Sur", takings.getTotalSurcharges());
        this.addItem("Del", takings.getCostOfDeletedItems());
        this.addItem("AccAdd", takings.getTotalNettDebtorsAdded());
        this.addItem("AccPd", takings.getTotalNettDebtorsPaid());
        return this.message;
    }

    private void addItem(String title, Price sales) {
        if (!sales.equals((Object)Price.ZERO)) {
            String name = title.trim();
            if (name.length() > 7) {
                name = name.substring(0, 6);
            }
            this.message = this.message + "\n" + title + " " + sales;
        }
    }
}

