/*
 * Decompiled with CFR 0.152.
 */
package servermate.scripts;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import servermate.scripts.UpdateMateScriptProcessor;
import updatemate.client.ClientUpdateWSClient;

public class UpdateMateScriptFileWatchTask
extends TimerTask {
    private static UpdateMateScriptFileWatchTask instance;
    private static final String SUCCESS_FOLDER = "/success";
    private static final String FAIL_FOLDER = "/fail";
    private static final String GROOVY_EXT = ".groovy";
    private static final DateFormat DATE_FORMATTER;
    private static final FilenameFilter filter;
    private ClientUpdateWSClient updater;
    private Semaphore latch = new Semaphore(1);

    private UpdateMateScriptFileWatchTask(ClientUpdateWSClient updater) {
        this.updater = updater;
    }

    public void runNow() {
        OrderMate.LOG.info("Call to run UpdateScript File Watcher run manually");
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.latch.tryAcquire()) {
            OrderMate.LOG.info("Cannot run UpdateMate file watcher, latch already caught");
            return;
        }
        try {
            File[] files;
            UpdateMateScriptProcessor scriptProcessor = new UpdateMateScriptProcessor(this.updater);
            String directoryPath = SystemProperty.getInstance().getUpdateMateScriptDir();
            for (File file : files = this.getFiles(directoryPath)) {
                try {
                    if (scriptProcessor.process(file)) {
                        this.createResultFileAndDeleteScript(file, SUCCESS_FOLDER);
                        continue;
                    }
                    this.createResultFileAndDeleteScript(file, FAIL_FOLDER);
                }
                catch (Throwable ex) {
                    OrderMate.LOG.error("Error processing script: " + file, ex);
                    this.createResultFileAndDeleteScript(file, FAIL_FOLDER);
                }
            }
        }
        finally {
            this.latch.release();
        }
    }

    private void createResultFileAndDeleteScript(File toMove, String folder) {
        File destination = new File(toMove.getParent() + folder);
        if (!destination.exists()) {
            destination.mkdir();
        }
        try {
            int idx = toMove.getName().indexOf(GROOVY_EXT);
            String fileName = toMove.getName().substring(0, idx) + " " + DATE_FORMATTER.format(Calendar.getInstance().getTime()) + GROOVY_EXT;
            new File(destination, fileName).createNewFile();
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Error createing script result file.", (Throwable)ex);
        }
        if (toMove.delete()) {
            OrderMate.LOG.warn("Successfully deleted: " + toMove);
        } else {
            OrderMate.LOG.error("Could not delete file: " + toMove);
        }
    }

    private File[] getFiles(String path) {
        File directory = new File(path);
        if (directory.exists() && directory.isDirectory()) {
            return directory.listFiles(filter);
        }
        if (!directory.mkdirs()) {
            OrderMate.LOG.warn(path + " does not exist or is not a directory.  Exists? " + directory.exists());
        }
        return new File[0];
    }

    public static UpdateMateScriptFileWatchTask init(ClientUpdateWSClient updateClient) {
        instance = new UpdateMateScriptFileWatchTask(updateClient);
        return instance;
    }

    public static UpdateMateScriptFileWatchTask getInstance() {
        return instance;
    }

    static {
        DATE_FORMATTER = new SimpleDateFormat("dd-MM-yy HH-mm");
        filter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(UpdateMateScriptFileWatchTask.GROOVY_EXT);
            }
        };
    }
}

