/*
 * Decompiled with CFR 0.152.
 */
package servermate.services;

import au.com.ordermate.dockets.DocketImageFinder;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import ordermate.database.misc.resource.DocketImage;

public class ServermateDocketImageFinder
extends DocketImageFinder {
    public static final int maxSize = 10;
    private LinkedHashMap<String, RenderedImage> imageMap = new LinkedHashMap<String, RenderedImage>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, RenderedImage> eldest) {
            return this.size() > 10;
        }
    };

    public synchronized RenderedImage findImage(String imageKey) {
        DocketImage docketImage;
        if (this.imageMap.containsKey(imageKey)) {
            return this.imageMap.get(imageKey);
        }
        String[] splits = imageKey.split("::");
        if (splits.length == 2 && (docketImage = (DocketImage)PersistenceManager.getObject(DocketImage.class, (String)Query.select(DocketImage.class).equals(DocketImage.Properties.LABEL, (Object)splits[1]).equals(DocketImage.Properties.IMAGE_GROUP, (Object)splits[0]).limit(1).toString())) != null) {
            BufferedImage render = docketImage.getImage().getImage();
            if (render != null) {
                this.imageMap.put(imageKey, render);
            }
            return render;
        }
        return null;
    }

    public synchronized void clearCache() {
        this.imageMap.clear();
    }
}

