/*
 * Decompiled with CFR 0.152.
 */
package servermate.services.voucher;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.Price;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.giftvoucher.VoucherAuthority;
import ordermate.database.finance.giftvoucher.VoucherError;
import ordermate.database.finance.giftvoucher.VoucherRequest;
import ordermate.database.finance.giftvoucher.VoucherResponse;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.BarcodePrefix;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.users.User;
import servermate.services.voucher.LocalVoucherMinion;

public class LocalVoucherAuthority
implements VoucherAuthority {
    private GiftVoucherConfiguration config;
    private LocalVoucherMinion minion;
    private BarcodePrefix barcodePrefix;

    protected LocalVoucherAuthority(GiftVoucherConfiguration yourConfig) {
        this.config = yourConfig;
        this.minion = this.createMinion(this.config);
        this.barcodePrefix = (BarcodePrefix)PersistenceManager.getObject(BarcodePrefix.class, (String)Query.select(BarcodePrefix.class).equals(BarcodePrefix.Properties.INTERNAL, 1.0).equals(BarcodePrefix.Properties.NAME, (Object)"GiftVoucher").limit(1).toString());
    }

    protected LocalVoucherMinion createMinion(GiftVoucherConfiguration theConfig) {
        return new LocalVoucherMinion(theConfig);
    }

    private LocalVoucherMinion getMinion() {
        if (this.config.isPersistent() && this.config.hasChanged()) {
            this.config = (GiftVoucherConfiguration)PersistenceManager.reacquire((PersistentObjectI)this.config);
            this.minion.setConfig(this.config);
        }
        return this.minion;
    }

    public VoucherResponse getVoucher(VoucherRequest request) {
        GiftVoucher voucher = this.getMinion().resolveVoucher(request.getUUID());
        VoucherResponse response = new VoucherResponse(request, voucher != null, null);
        response.setVoucher(voucher);
        if (voucher == null) {
            response.setError(VoucherError.NOT_EXISTS);
        }
        return response;
    }

    public VoucherResponse resyncVoucher(VoucherRequest request) {
        VoucherResponse response = this.getMinion().lockAndCheck(request);
        if (response == null) {
            GiftVoucher voucher = request.getVoucher();
            this.getMinion().doResync(voucher);
            this.getMinion().unlockVoucher(voucher);
            response = new VoucherResponse(request, true, null);
            response.setVoucher(voucher);
        }
        return response;
    }

    public VoucherResponse createVoucher(VoucherRequest request) {
        VoucherResponse response = this.getMinion().createVoucher(request);
        return response;
    }

    public VoucherResponse topupVoucher(VoucherRequest request) {
        VoucherResponse response = this.getMinion().lockAndCheck(request);
        if (response == null) {
            GiftVoucher voucher;
            response = this.getMinion().checkValid(request, false, false);
            if (response == null && (voucher = request.getVoucher()) != null) {
                voucher = (GiftVoucher)PersistenceManager.reacquire((PersistentObjectI)voucher);
                String nextId = this.getMinion().getNextAuthCode();
                response = new VoucherResponse(request, true, nextId);
                response.setVoucher(voucher);
                GiftVoucherTransaction txn = request.getTransaction();
                txn.authorise(nextId);
                response.setTxn(txn);
            }
            this.getMinion().unlockVoucher(request.getVoucher());
        }
        return response;
    }

    public VoucherResponse redeemVoucher(VoucherRequest request) {
        VoucherResponse response = this.getMinion().lockAndCheck(request);
        if (response == null) {
            response = this.getMinion().checkValid(request, true, true);
            if (response == null) {
                GiftVoucher voucher = request.getVoucher();
                Price value = this.getMinion().doResync(voucher);
                if (request.getTransaction().getAmount().add(value).lessThan((Object)Price.ZERO_DOLLAR)) {
                    response = this.getMinion().fail(request, VoucherError.INSUFFICIENT_FUNDS);
                } else {
                    voucher.setCachedValue(value.add(request.getTransaction().getAmount()));
                    String nextId = this.getMinion().getNextAuthCode();
                    response = new VoucherResponse(request, true, nextId);
                    response.setVoucher(voucher);
                    response.setTxn(request.getTransaction());
                    response.getTxn().setVoucherBalance(voucher.getCachedValue());
                    response.getTxn().authorise(nextId);
                    voucher.save();
                }
            }
            this.getMinion().unlockVoucher(request.getVoucher());
        }
        return response;
    }

    public VoucherResponse cancelTransaction(VoucherRequest request) {
        VoucherResponse response = this.getMinion().lockAndCheck(request);
        if (response == null) {
            GiftVoucherTransaction txn = request.getTransaction();
            response = new VoucherResponse(request, true, txn.getAuthId());
            GiftVoucher voucher = request.getVoucher();
            response.setVoucher(voucher);
            response.setTxn(txn);
            if (txn.isAuthorised()) {
                if (txn.isConfirmed()) {
                    OrderMate.LOG.warn("Cannot cancel a confirmed transaction.");
                    return this.getMinion().fail(request, VoucherError.CANNOT_CANCEL_CONFIRMED);
                }
                if (response.getError() == null) {
                    if (txn.isReversal()) {
                        voucher.setCachedValue(voucher.getCachedValue().add(txn.getAmount().negate()));
                    }
                    txn.deleteTransaction();
                    for (GiftVoucherTransaction nextTxn : voucher.getTransactions()) {
                        if (!nextTxn.equals((Object)txn)) continue;
                        nextTxn.deleteTransaction();
                        nextTxn.saveChild();
                    }
                }
            } else {
                txn.deleteTransaction();
            }
            txn.saveChild();
            voucher.save();
            this.getMinion().unlockVoucher(request.getVoucher());
        }
        return response;
    }

    public VoucherResponse reverseTransaction(VoucherRequest request) {
        VoucherResponse response = this.getMinion().lockAndCheck(request);
        if (response == null) {
            response = this.getMinion().checkValid(request, false, true);
            if (response == null) {
                GiftVoucher voucher = request.getVoucher();
                Price value = this.getMinion().doResync(voucher);
                GiftVoucherTransaction originalTxn = request.getTransaction();
                if (originalTxn.isPositive()) {
                    voucher.setCachedValue(value.add(request.getTransaction().getAmount().negate()));
                }
                GiftVoucherTransaction reversalTxn = new GiftVoucherTransaction(originalTxn.getAmount().negate(), originalTxn.getGiftVoucher(), null, null, originalTxn.getAccount(), new EventContext(Terminal.getLocalHost(), User.getSystemUser()));
                reversalTxn.setExpiryDate(new Date());
                reversalTxn.setExpiryTime(new Date());
                reversalTxn.setReversedVoucherTransaction(originalTxn);
                reversalTxn.setVoucherBalance(voucher.getCachedValue());
                originalTxn.setExpiryDate(new Date());
                originalTxn.setExpiryTime(new Date());
                String nextId = this.getMinion().getNextAuthCode();
                response = new VoucherResponse(request, true, nextId);
                response.setVoucher(voucher);
                response.setTxn(reversalTxn);
                response.getTxn().setVoucherBalance(voucher.getCachedValue());
                response.getTxn().authorise(nextId);
                voucher.addGiftVoucherTransaction(reversalTxn);
                voucher.save();
            }
            this.getMinion().unlockVoucher(request.getVoucher());
        }
        return response;
    }

    public boolean isHandled(String UUID) {
        if (UUID == null || UUID.isEmpty()) {
            return false;
        }
        String toTest = UUID.trim();
        if (toTest.startsWith(this.barcodePrefix.getPrefix())) {
            toTest = toTest.substring(this.barcodePrefix.getPrefix().length());
        }
        if (!toTest.startsWith(this.config.getPrefix())) {
            return false;
        }
        return toTest.length() == this.config.getUuidLength() + this.config.getPrefix().length();
    }

    public GiftVoucherConfiguration getConfiguration() {
        return this.config;
    }

    public String toString() {
        return this.config.getLabel();
    }

    public Integer getVoucherDefaultExpiryPeriod() {
        if (this.config.hasChanged()) {
            this.config = (GiftVoucherConfiguration)PersistenceManager.reacquire((PersistentObjectI)this.config);
        }
        return this.config.getDefaultExpiryPeriod();
    }

    public VoucherResponse confirmTransaction(VoucherRequest request) {
        VoucherResponse response = this.getMinion().lockAndCheck(request);
        if (response == null) {
            GiftVoucherTransaction txn = request.getTransaction();
            GiftVoucher voucher = request.getVoucher();
            if (txn.isPositive()) {
                voucher.setCachedValue(voucher.getCachedValue().add(txn.getAmount()));
            }
            txn.setVoucherBalance(voucher.getCachedValue());
            txn.confirm();
            PersistenceManager.saveChild((PersistentObject)txn);
            voucher.save();
            this.getMinion().unlockVoucher(voucher);
            response = new VoucherResponse(request, true, txn.getAuthId());
        }
        return response;
    }
}

