/*
 * Decompiled with CFR 0.152.
 */
package servermate.services.voucher.expiry;

import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.giftvoucher.VoucherRequest;
import servermate.services.voucher.expiry.VoucherExpiryValidationStrategy;

public class LatestTransactionExpiryStrategy
implements VoucherExpiryValidationStrategy {
    @Override
    public boolean validateExpiryDate(VoucherRequest request) {
        Date expiry;
        GiftVoucher voucher = request.getVoucher();
        if (voucher == null) {
            return false;
        }
        Date latestExpiryDate = null;
        Date latestExpiryTime = null;
        for (GiftVoucherTransaction vTran : voucher.getTransactions()) {
            if (vTran.isRedeeming()) continue;
            if (latestExpiryDate == null) {
                latestExpiryDate = vTran.getExpiryDate();
                latestExpiryTime = vTran.getExpiryTime();
                continue;
            }
            if (!vTran.getExpiryDate().after(latestExpiryDate)) continue;
            latestExpiryDate = vTran.getExpiryDate();
            latestExpiryTime = vTran.getExpiryTime();
        }
        if (latestExpiryDate == null) {
            return true;
        }
        Date now = DateTimeUtils.combineDateAndTime((Date)request.getTransaction().getCreationDate(), (Date)request.getTransaction().getCreationTime());
        return !now.after(expiry = DateTimeUtils.combineDateAndTime((Date)latestExpiryDate, latestExpiryTime));
    }
}

