/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets;

import au.com.ordermate.OrderMateLog;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class ServerMateServer
extends Server {
    private static final int DEFAULT_PORT = 8081;
    private ServletContextHandler servletContext;
    private static Map<String, ServerMateServer> servers;

    private ServerMateServer(String namespace, int port) {
        super(port);
        this.servletContext = new ServletContextHandler((HandlerContainer)this, namespace);
    }

    public static final ServerMateServer getServer(String namespace, int defaultPort) {
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace cannot be null");
        }
        int port = defaultPort;
        if (defaultPort == -1) {
            port = 8081;
        }
        if (servers == null) {
            servers = new HashMap<String, ServerMateServer>();
        }
        if (!servers.containsKey(namespace)) {
            ServerMateServer server = new ServerMateServer(namespace, port);
            servers.put(namespace, server);
        }
        return servers.get(namespace);
    }

    public static final void dropServer(String namespace) {
        if (servers != null) {
            servers.remove(namespace);
        }
    }

    public static final void dropServer(Server server) {
        if (servers != null) {
            for (String key : servers.keySet()) {
                if (!((Object)((Object)servers.get(key))).equals(server)) continue;
                servers.remove(key);
                break;
            }
        }
    }

    public ServletContextHandler getServletContext() {
        return this.servletContext;
    }

    public void addServlet(Servlet servlet, String path) {
        ServletHolder holder = new ServletHolder(servlet);
        this.applyServletHolder(holder, path);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.handle(target, baseRequest, request, response);
    }

    public void applyServletHolder(ServletHolder holder, String path) {
        this.servletContext.addServlet(holder, path);
        OrderMateLog.LOG.info("Starting servlet:" + holder.getDisplayName() + " on " + path);
    }

    public void applyServletHolderNoLog(ServletHolder holder, String path) {
        this.servletContext.addServlet(holder, path);
        System.out.println("Starting servlet:" + holder.getDisplayName() + " on " + path);
    }
}

