/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.jersey;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.servlet.Filter;
import ordermate.OrderMate;
import ordermate.database.config.webresource.WebResource;
import ordermate.database.integration.WebResourceIntegration;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import servermate.servlets.ServerMateServer;
import servermate.servlets.filter.IPAddressFilter;
import servermate.servlets.filter.LoggingFilter;
import servermate.servlets.filter.WebResourceUserPassFilter;
import servermate.servlets.jersey.WebResourceSetup;

public class IntegrationWebServer {
    private static volatile IntegrationWebServer webServer;
    private static final String INTEGRATION_SERVLET_CONTEXT = "/integration";
    private static final int DEFAULT_PORT = 8090;
    private static final String RESOURCE_DIRECTORY = "C:/Temp/OM/JerseyServetResource";
    private ServerMateServer smServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IntegrationWebServer getInstance() {
        if (webServer != null) return webServer;
        Class<IntegrationWebServer> clazz = IntegrationWebServer.class;
        synchronized (IntegrationWebServer.class) {
            if (webServer != null) return webServer;
            webServer = new IntegrationWebServer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return webServer;
        }
    }

    public void restart() throws Exception {
        this.stopTheServer();
        this.startTheServer();
    }

    private void stopTheServer() throws Exception {
        if (this.smServer != null) {
            this.smServer.stop();
            this.smServer = null;
            ServerMateServer.dropServer(INTEGRATION_SERVLET_CONTEXT);
        }
    }

    private void startTheServer() throws Exception {
        WebResourceIntegration.reacquire();
        WebResourceIntegration integration = WebResourceIntegration.getInstance();
        if (!integration.isEnabled()) {
            OrderMate.LOG.info("Integrated Web Resources are not enabled.");
            return;
        }
        List resources = PersistenceManager.getObjectList(WebResource.class, (String)Query.select(WebResource.class).active(WebResource.class).toString());
        HashSet<WebResourceSetup> servletSetups = new HashSet<WebResourceSetup>();
        for (WebResource nextResource : resources) {
            if (nextResource.getResourceType() == null) continue;
            LicenseType license = nextResource.getResourceType().getLicenseType();
            if (license != null && !PersistentLicenseManager.getInstance().getBoolean(license)) {
                OrderMate.LOG.info("Web Resource " + nextResource.getResourceType() + " is not licensed. Will not activate.");
                continue;
            }
            servletSetups.add(new WebResourceSetup(nextResource));
        }
        int port = 8090;
        if (integration.getPort() != null) {
            port = integration.getPort();
        }
        this.writeResourceFiles();
        this.smServer = ServerMateServer.getServer(INTEGRATION_SERVLET_CONTEXT, port);
        this.smServer.setHandler(this.createHandler());
        FilterHolder crossOriginHolder = new FilterHolder((Filter)new CrossOriginFilter());
        crossOriginHolder.setInitParameter("url-pattern", "/*");
        crossOriginHolder.setInitParameter("allowedOrigins", "*");
        for (WebResourceSetup servletSetup : servletSetups) {
            OrderMate.LOG.info("Adding Web Resource " + servletSetup);
            if (servletSetup.requiresLogging()) {
                FilterHolder loggingHolder = new FilterHolder((Filter)new LoggingFilter(servletSetup.getLogConfig()));
                this.smServer.getServletContext().addFilter(loggingHolder, servletSetup.getContextPath(), null);
            }
            if (servletSetup.isRequiresIPFilter()) {
                FilterHolder ipAddressHolder = new FilterHolder((Filter)new IPAddressFilter(true, servletSetup.getWhiteList()));
                this.smServer.getServletContext().addFilter(ipAddressHolder, servletSetup.getContextPath(), null);
            }
            if (servletSetup.isRequiresUserFilter()) {
                FilterHolder userPassHolder = new FilterHolder((Filter)new WebResourceUserPassFilter(servletSetup.getResource()));
                this.smServer.getServletContext().addFilter(userPassHolder, servletSetup.getContextPath(), null);
            }
            this.smServer.getServletContext().addFilter(crossOriginHolder, servletSetup.getContextPath(), null);
            servletSetup.setupContainer(this.smServer);
        }
        if (!this.smServer.isStarted()) {
            this.smServer.start();
        }
    }

    public boolean isStarted() {
        if (this.smServer != null) {
            return this.smServer.isStarted();
        }
        return false;
    }

    private Handler createHandler() {
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(false);
        resourceHandler.setResourceBase(RESOURCE_DIRECTORY);
        HandlerList handlers = new HandlerList();
        Handler[] oldHandlers = this.smServer.getHandlers();
        Handler[] newHandlers = new Handler[oldHandlers.length + 1];
        System.arraycopy(oldHandlers, 0, newHandlers, 1, oldHandlers.length);
        newHandlers[0] = resourceHandler;
        handlers.setHandlers(newHandlers);
        return handlers;
    }

    private void writeResourceFiles() {
        File file = new File("C:/Temp/OM/JerseyServetResource/crossdomain.xml");
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                if (file.createNewFile()) {
                    FileWriter write = new FileWriter(file);
                    write.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<cross-domain-policy>\n\t<allow-access-from domain=\"*\"/>\n</cross-domain-policy>");
                    write.close();
                }
            }
            catch (IOException e) {
                OrderMate.LOG.error("Error writing to C:/Temp/OM/JerseyServetResource/crossdomain.xml! ", (Throwable)e);
            }
        }
    }
}

