/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.payattable;

import au.com.payback.xmlintegration.payattable.ObjectFactory;
import au.com.payback.xmlintegration.payattable.PaTAccount;
import au.com.payback.xmlintegration.payattable.PaTAccountItem;
import au.com.payback.xmlintegration.payattable.PaTAccountList;
import au.com.payback.xmlintegration.payattable.PaTCustomer;
import au.com.payback.xmlintegration.payattable.PaTUser;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.transactions.FinanceTransactionItemHelper;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.sales.TableAccount;
import ordermate.database.users.User;

class PayAtTableEntityHelper {
    private static final ObjectFactory FACTORY = new ObjectFactory();

    PayAtTableEntityHelper() {
    }

    static final PaTAccountList convertAccountList(List<Account> accounts) {
        PaTAccountList accList = FACTORY.createPaTAccountList();
        ArrayList<Account> failedAccList = new ArrayList<Account>();
        if (accounts == null) {
            return accList;
        }
        for (Account account : accounts) {
            PaTAccount accItem = PayAtTableEntityHelper.convertAccount(account);
            if (accItem != null) {
                accList.getAccounts().add(accItem);
                continue;
            }
            failedAccList.add(account);
        }
        if (failedAccList.size() > 0) {
            OrderMate.LOG.info(failedAccList.size() + " account(s) could not be converted into PaTAccount, please review accounts");
            for (Account a : failedAccList) {
                OrderMate.LOG.info("Failed To Convert Account " + a.getID());
            }
        }
        return accList;
    }

    static final PaTAccount convertAccount(Account account) {
        if (account == null) {
            return null;
        }
        try {
            PaTAccount patAccount = FACTORY.createPaTAccount();
            if (AccountType.tableType.equals((Object)account.getAccountType())) {
                if (((TableAccount)account).getTable() == null) {
                    patAccount.setTableNumber("Unallocated Table " + ((TableAccount)account).getID());
                    patAccount.setLabel("Unallocated Table " + ((TableAccount)account).getID());
                } else {
                    patAccount.setTableNumber(((TableAccount)account).getTable().getPrimaryPhysicalTable().getName());
                    patAccount.setLabel(account.getLabel());
                }
            } else {
                patAccount.setLabel(account.getLabel());
                try {
                    if (AccountType.barTabType.equals((Object)account.getAccountType()) && ((BarTabAccount)account).getLogicalTable() != null) {
                        patAccount.setTableNumber(((BarTabAccount)account).getLogicalTable().getPrimaryPhysicalTable().getName());
                    }
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Cannot convert bartab's table", (Throwable)ex);
                }
            }
            patAccount.setAccountId(account.getID());
            patAccount.setAccountType(account.getAccountType().getType());
            patAccount.setCustomer(PayAtTableEntityHelper.convertCustomer(account.getCustomer()));
            patAccount.setDue(account.getDue().toBigDecimal());
            patAccount.setOpenTime(account.getCreationDateTime().getTime());
            patAccount.setPaid(account.getPaid().toBigDecimal());
            patAccount.setTax(account.getTax().toBigDecimal());
            patAccount.setTotal(account.getTotal().toBigDecimal());
            patAccount.setCovers(account.getNumPatrons());
            for (SalesLineItem item : account.getItems()) {
                patAccount.getItems().add(PayAtTableEntityHelper.convertSalesItem(item));
            }
            return patAccount;
        }
        catch (Exception e) {
            OrderMate.LOG.error("Cannot convert account to PaTAccount, skipping table", (Throwable)e);
            return null;
        }
    }

    static final PaTAccountItem convertSalesItem(SalesLineItem item) {
        if (item == null) {
            return null;
        }
        PaTAccountItem accItem = FACTORY.createPaTAccountItem();
        accItem.setCourse(Integer.valueOf(item.getCourse()));
        accItem.setCustomer(PayAtTableEntityHelper.convertCustomer(item.getCustomer()));
        accItem.setLabel(item.getLabel());
        accItem.setPrice(item.getPrice().toBigDecimal());
        accItem.setQty(item.getQuantity().getValue());
        accItem.setSeat(Integer.valueOf(item.getSeat()));
        accItem.setTax(item.getTax().toBigDecimal());
        accItem.setIsPaid(Boolean.valueOf(FinanceTransactionItemHelper.getInstance().getItemIsPaidOff(item)));
        BigDecimal totalFinalSurcharge = BigDecimal.valueOf(0L);
        for (SalesItem salesItem : item.getSalesItems()) {
            for (SalesComponent currentComponent : salesItem.getComponentList()) {
                for (SalesPriceAdjustmentUsage adj : currentComponent.getPriceAdjustmentUsages()) {
                    if (!PriceAdjustmentType.FINAL.equals((Object)adj.getSalesPriceAdjustment().getType()) && !PriceAdjustmentType.FINAL_PAYMENT.equals((Object)adj.getSalesPriceAdjustment().getType()) || !PriceAdjustmentDirection.SURCHARGE.equals((Object)adj.getSalesPriceAdjustment().getDirection())) continue;
                    totalFinalSurcharge = totalFinalSurcharge.add(BigDecimal.valueOf(adj.getUnitValue().negate().getOriginalRawValue()).multiply(salesItem.getQuantity().getValue())).setScale(2, RoundingMode.HALF_EVEN);
                    OrderMate.LOG.info("Item: " + salesItem.getLabel() + "[] " + adj.getUnitValue().toBigDecimal().multiply(salesItem.getQuantity().getValue()));
                }
            }
        }
        OrderMate.LOG.info(item.getLabel() + " - Total: " + totalFinalSurcharge);
        accItem.setSurcharge(totalFinalSurcharge.setScale(2, RoundingMode.HALF_EVEN));
        accItem.setId(item.getID());
        accItem.setTaxable(Boolean.TRUE);
        return accItem;
    }

    static final PaTCustomer convertCustomer(Customer customer) {
        if (customer == null) {
            return null;
        }
        PaTCustomer cust = FACTORY.createPaTCustomer();
        if (customer.getCategory() != null) {
            cust.setCategoryId(customer.getCategory().getID());
        }
        cust.setEmail(customer.getEmail());
        cust.setName(customer.getName());
        cust.setPhone(customer.getPrimaryPhoneNumber());
        return cust;
    }

    static final PaTUser convertUser(User user, PaTUser patUser) {
        if (user == null) {
            return null;
        }
        patUser.setName(user.getName());
        patUser.setUserId(user.getID());
        return patUser;
    }

    static void redistributeFinalPriceAdjustments(PaTAccount account, List<SalesPriceAdjustment> adjustments) {
        BigDecimal total = account.getTotal();
        for (SalesPriceAdjustment adjustment : adjustments) {
            total = PayAtTableEntityHelper.removeFinalPriceAdjustment(account, adjustment, total);
        }
        for (SalesPriceAdjustment adjustment : adjustments) {
            PayAtTableEntityHelper.addFinalPriceAdjustment(account, adjustment, true);
        }
    }

    static BigDecimal removeFinalPriceAdjustment(PaTAccount account, SalesPriceAdjustment adjustment, BigDecimal total) {
        if (!adjustment.getUnit().equals((Object)PriceAdjustmentUnit.FINAL_UNIT)) {
            return total;
        }
        for (PaTAccountItem item : account.getItems()) {
            BigDecimal perc = item.getPrice().divide(total, RoundingMode.HALF_EVEN);
            BigDecimal adjustmentShare = item.getPrice().subtract(adjustment.getValue().toBigDecimal().add(total).multiply(perc)).setScale(2, RoundingMode.HALF_EVEN);
            item.setPrice(item.getPrice().subtract(adjustmentShare).setScale(2, RoundingMode.HALF_EVEN));
            item.setSurcharge(item.getSurcharge().subtract(adjustmentShare).setScale(2, RoundingMode.HALF_EVEN));
        }
        return total.add(adjustment.getValue().toBigDecimal()).setScale(2, RoundingMode.HALF_EVEN);
    }

    static void addFinalPriceAdjustment(PaTAccount account, SalesPriceAdjustment adjustment, boolean paidOnly) {
        List accountItems = account.getItems();
        BigDecimal paidTotal = BigDecimal.ZERO;
        for (PaTAccountItem item : accountItems) {
            if (paidOnly && !item.getIsPaid().booleanValue()) continue;
            paidTotal = paidTotal.add(item.getPrice());
        }
        for (PaTAccountItem item : accountItems) {
            if (paidOnly && !item.getIsPaid().booleanValue()) continue;
            BigDecimal perc = item.getPrice().divide(paidTotal, RoundingMode.HALF_EVEN);
            BigDecimal adjustmentShare = adjustment.getValue().toBigDecimal().multiply(perc).setScale(2, RoundingMode.HALF_EVEN);
            item.setPrice(item.getPrice().subtract(adjustmentShare).setScale(2, RoundingMode.HALF_EVEN));
            item.setSurcharge(item.getSurcharge().subtract(adjustmentShare).setScale(2, RoundingMode.HALF_EVEN));
        }
    }
}

