/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.payattable;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import au.com.payback.xmlintegration.payattable.PaTAccountItem;
import au.com.payback.xmlintegration.payattable.PaTError;
import au.com.payback.xmlintegration.payattable.PaTPaymentResult;
import au.com.payback.xmlintegration.payattable.PaTResult;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.finance.transactions.DebitTransaction;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionItemHelper;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;
import ordermate.integration.eftpos.adyen.AdyenUtils;
import ordermate.webresource.adyen.AdyenOPayUtils;
import servermate.servlets.payattable.PayAtTableErrors;

public class PayAtTableResourceHelper {
    static final AccountType resolveAccountType(String accountType) {
        List<AccountType> types = Arrays.asList(AccountType.getTypes());
        for (AccountType type : types) {
            if (!type.getType().equalsIgnoreCase(accountType)) continue;
            return type;
        }
        return AccountType.tableType;
    }

    public boolean isDuplicateTransaction(PaTPaymentResult payment) {
        FinanceTransaction duplicate = (FinanceTransaction)PersistenceManager.getObject(FinanceTransaction.class, (String)Query.select(FinanceTransaction.class).wherePropertyLike(FinanceTransaction.Properties.TRANSACTION_REFERENCE, payment.getTransactionUuid()).toString());
        if (duplicate != null) {
            return this.checkStringFormatAndMatch(duplicate.getTransactionReference(), payment.getTransactionUuid());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaTPaymentResult doPayment(PaTPaymentResult payment) {
        Account account = (Account)PersistenceManager.getByID((long)payment.getAccountId(), Account.class);
        User user = account != null && account.getUser() != null ? account.getUser() : User.getSystemUser();
        Terminal terminal = Terminal.getServerMateTerminal();
        CashDrawer cd = this.resolveCashDrawer(terminal);
        if (payment.getCashdrawerId() != null && !Long.valueOf(0L).equals(payment.getCashdrawerId())) {
            cd = (CashDrawer)PersistenceManager.getByID((long)payment.getCashdrawerId(), CashDrawer.class);
        }
        if (account == null) {
            OrderMate.LOG.error("SEVERE: An incoming payment from PayAtTable has been made but belongs to an unknown account (ID=" + payment.getAccountId() + ")!");
            PaTError error = PayAtTableErrors.getError(PayAtTableErrors.CODE_ERROR_UNKNOWN_ACCOUNT);
            error = PayAtTableErrors.appendStringToMessage(error, payment.getAccountId() + ".");
            payment.setError(error);
            payment.setStatus(PaTResult.ERROR);
            return payment;
        }
        if (cd == null) {
            OrderMate.LOG.error("SEVERE: An incoming payment from PayAtTable has been made but a valid cashdrawer could not be found!");
            payment.setStatus(PaTResult.ERROR);
            payment.setError(PayAtTableErrors.getError(PayAtTableErrors.CODE_ERROR_PAY_NO_CASHDRAWER));
            return payment;
        }
        if (!account.isOpen()) {
            OrderMate.LOG.error("SEVERE: An incoming payment from PayAtTable has been made but the target account (ID=" + payment.getAccountId() + ") is already closed!");
            payment.setStatus(PaTResult.ERROR);
            payment.setError(PayAtTableErrors.getError(PayAtTableErrors.CODE_ERROR_ACC_ALREADY_CLOSED));
            return payment;
        }
        if (account.isLocked() || account.lock(user)) {
            FinanceTransaction toAdd = this.createTransaction(payment, user, terminal, cd);
            if (payment.getCardString() != null) {
                toAdd.setMaskedCardNumber(payment.getCardString());
            }
            if (payment.getItems() != null && !payment.getItems().isEmpty()) {
                toAdd.applyAccount(account);
                toAdd.saveChild();
                for (PaTAccountItem accItem : payment.getItems()) {
                    SalesLineItem item = (SalesLineItem)PersistenceManager.getByID((long)accItem.getId(), SalesLineItem.class);
                    if (accItem.getPaidQty() != null && accItem.getPaidQty().compareTo(accItem.getQty()) == -1) {
                        SalesLineItem newItem = item.split(new SalesQuantity(accItem.getPaidQty()), new EventContext(terminal, user));
                        newItem.saveChild();
                        item.saveChild();
                        item = newItem;
                    }
                    item.addFinanceTransaction(toAdd);
                    item.saveChild();
                    FinanceTransactionItemHelper.getInstance().setItemIsPaidOff(item);
                    account.save();
                    account = (Account)PersistenceManager.reacquire((PersistentObjectI)account);
                }
            } else {
                account.addFinanceTransaction(toAdd);
            }
            if (payment.getSurcharge() != null && BigDecimal.ZERO.compareTo(payment.getSurcharge()) < 0) {
                FinanceSurchargeCalculator.applySurcharge((Payable)account, (FinanceUnit)toAdd.getSubType(), (Price)new Price((Number)payment.getSurcharge(), 0.01), (EventContext)new EventContext(terminal, user));
            }
            try {
                this.closeAccount(account, terminal, user);
            }
            finally {
                account.prepareForSave(account.createSaveContext(null, null, terminal));
                account.save();
                account.unlock();
            }
            payment.setError(null);
        } else {
            OrderMate.LOG.error("SEVERE: An incoming payment from PayAtTable has been made but the account is not locked, nor can the lock be acquired!");
            payment.setStatus(PaTResult.ERROR);
            payment.setError(PayAtTableErrors.getError(PayAtTableErrors.CODE_ERROR_ACC_CANNOT_LOCK));
        }
        return payment;
    }

    private void closeAccount(Account acc, Terminal terminal, User user) {
        ExperimentalFeature feature = ExperimentalFeature.find((String)"Opay Close 1c Accounts");
        if (feature == null || !feature.getBooleanValue(Boolean.valueOf(false)).booleanValue()) {
            if (Price.ZERO_DOLLAR.equals((Object)acc.getDue())) {
                acc.close(new EventContext(terminal, user));
            }
        } else if (Price.ZERO_DOLLAR.approximatelyEquals(acc.getDue())) {
            acc.close(new EventContext(terminal, user));
        }
    }

    public CashDrawer resolveCashDrawer(Terminal terminal) {
        if (AdyenIntegrationConfig.getInstance().isConfigured() && AdyenIntegrationConfig.getInstance().getCashdrawer() != null) {
            return AdyenIntegrationConfig.getInstance().getCashdrawer();
        }
        User user = User.getSystemUser();
        if (terminal == null) {
            return null;
        }
        List cds = CashDrawer.getAvailableCashDrawers((Terminal)terminal, (User)user);
        if (cds != null && !cds.isEmpty()) {
            return (CashDrawer)cds.get(0);
        }
        List servermateCashdrawers = terminal.getConnectedCashDrawers();
        if (servermateCashdrawers != null && !servermateCashdrawers.isEmpty()) {
            return (CashDrawer)servermateCashdrawers.get(0);
        }
        List systemUserCashdrawers = terminal.getAvailableCashDrawers(User.getSystemUser());
        if (systemUserCashdrawers != null && !systemUserCashdrawers.isEmpty()) {
            return (CashDrawer)systemUserCashdrawers.get(0);
        }
        return null;
    }

    private FinanceTransaction createTransaction(PaTPaymentResult payment, User user, Terminal terminal, CashDrawer cashdrawer) {
        VirtualEftpos cfg;
        Price paid = new Price(payment.getPaid().doubleValue(), 0.0);
        Price tip = new Price(payment.getTip().doubleValue(), 0.0);
        FinanceUnit unit = AdyenOPayUtils.getFinanceUnitFor((PaTPaymentResult)payment);
        if (unit == null) {
            unit = AdyenUtils.getCardTypeFromBrand((String)payment.getFinanceUnit());
        }
        Object transaction = unit == null ? new DebitTransaction(user, terminal, paid, tip, Price.ZERO_DOLLAR, cashdrawer, FinanceUnit.getDefaultUnitFor((FinanceUnit.FinanceUnitType)FinanceUnit.DEBIT_TYPE), terminal.getShift()) : (FinanceUnit.DEBIT_TYPE.toString().equals(unit.getType()) ? new DebitTransaction(user, terminal, paid, tip, Price.ZERO_DOLLAR, cashdrawer, unit, terminal.getShift()) : (FinanceUnit.CREDIT_TYPE.toString().equals(unit.getType()) ? new CreditTransaction(user, terminal, paid, tip, cashdrawer, unit, terminal.getShift()) : new DebitTransaction(user, terminal, paid, tip, Price.ZERO_DOLLAR, cashdrawer, FinanceUnit.getDefaultUnitFor((FinanceUnit.FinanceUnitType)FinanceUnit.DEBIT_TYPE), terminal.getShift())));
        if (payment.getSurcharge() != null && BigDecimal.ZERO.compareTo(payment.getSurcharge()) < 0) {
            transaction.setSurcharge(new Price((Number)payment.getSurcharge(), 0.0));
        }
        transaction.setTransactionReference(payment.getTransactionUuid());
        transaction.setTransactionStatus(EftposTransaction.TransactionStatus.PROCESSED);
        if (payment.getPaymentTerminalId() != null && (cfg = (VirtualEftpos)PersistenceManager.getObject(VirtualEftpos.class, (String)Query.select(VirtualEftpos.class).active(VirtualEftpos.class).equals(VirtualEftpos.Properties.TERMINAL_ID, (Object)payment.getPaymentTerminalId()).equals(VirtualEftpos.Properties.EFTPOS_TYPE, (Object)EftposType.ADYEN).toString())) != null) {
            transaction.setVirtualEftpos(cfg);
        }
        if (payment.getStatus() != null && !PaTResult.APPROVED.equals((Object)payment.getStatus())) {
            transaction.setSystemState("DELETED");
        }
        return transaction;
    }

    private boolean checkStringFormatAndMatch(String input, String match) {
        if (input.equals(match)) {
            return true;
        }
        int dotIndex = input.lastIndexOf(46);
        if (dotIndex == -1) {
            return input.equals(match);
        }
        String firstPart = input.substring(0, dotIndex);
        String lastPart = input.substring(dotIndex + 1);
        return !firstPart.isEmpty() && !lastPart.isEmpty() && lastPart.equals(match);
    }
}

