/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.reporting;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.reports.TotalsReport;
import ordermate.database.misc.TradingDay;
import ordermate.database.searchers.reports.TotalsReportSearcher;

public class SalesComparisonCompiler {
    private Calendar referenceDate;
    private Date fromDate;
    private Date toDate;
    private boolean includeFullEndTradingDay = false;
    private SalesLocation salesLocation;
    public static final int TODAY = 0;
    public static final int LAST_WEEK_SAME_TIME = 1;
    public static final int YESTERDAY_FULL = 2;
    public static final int YESTERDAY_LAST_WEEK_FULL = 3;
    public static final int LAST_WEEK_FULL = 4;
    public static final int WEEK_TO_YESTERDAY = 5;
    public static final int WEEK_TO_DATE = 6;
    public static final int LAST_MONTH = 7;
    public static final int MONTH_TO_DATE = 8;
    public static final int MONTH_TO_YESTERDAY = 9;

    public SalesComparisonCompiler() {
        this.fromDate = Calendar.getInstance().getTime();
        this.toDate = Calendar.getInstance().getTime();
        this.includeFullEndTradingDay = false;
        this.salesLocation = null;
        this.referenceDate = Calendar.getInstance();
    }

    public SalesComparisonCompiler from(Date date) {
        this.fromDate = date;
        return this;
    }

    public SalesComparisonCompiler to(Date date) {
        this.toDate = date;
        return this;
    }

    public SalesComparisonCompiler includeFullEndTradingDay() {
        this.includeFullEndTradingDay = true;
        return this;
    }

    public SalesComparisonCompiler salesLocation(SalesLocation location) {
        this.salesLocation = location;
        return this;
    }

    public TotalsReport compile() {
        if (this.fromDate == null || this.toDate == null || this.toDate.compareTo(this.fromDate) < 0) {
            return new TotalsReport();
        }
        Date toTime = this.toDate;
        TradingDay fromTradingDay = this.getFirstTradingDayForDate(this.fromDate);
        if (fromTradingDay == null) {
            return new TotalsReport();
        }
        Date fromTime = fromTradingDay.getOpenDateTime();
        if (this.includeFullEndTradingDay) {
            TradingDay toTradingDay = this.getLastTradingDayForDate(this.toDate);
            if (toTradingDay == null) {
                return new TotalsReport();
            }
            toTime = toTradingDay.getCloseDateTime();
        }
        if (fromTime.getTime() >= toTime.getTime()) {
            return new TotalsReport();
        }
        TotalsReportSearcher searcher = new TotalsReportSearcher();
        searcher.getTradingDayRangeFilter().setStart((Comparable)fromTime);
        searcher.getTradingDayRangeFilter().setEnd((Comparable)toTime);
        if (this.salesLocation != null) {
            searcher.setTradingDayBySIQ(true);
            searcher.getSalesLocationFilter().setSearchValue((Object)this.salesLocation);
        }
        TotalsReport totalReport = new TotalsReport();
        for (TotalsReport report : searcher.search()) {
            totalReport.setTotal(totalReport.getTotal().add(report.getTotal()));
            totalReport.setTotalTax(totalReport.getTotalTax().add(report.getTotalTax()));
        }
        return totalReport;
    }

    public SalesComparisonCompiler preset(int preset) {
        return this.preset(Calendar.getInstance().getTime(), preset);
    }

    public SalesComparisonCompiler preset(Date referenceDate, int preset) {
        Calendar calendarFrom = Calendar.getInstance();
        calendarFrom.setTime(referenceDate);
        Calendar calendarTo = Calendar.getInstance();
        calendarTo.setTime(referenceDate);
        switch (preset) {
            case 0: {
                this.fromDate = referenceDate;
                this.toDate = referenceDate;
                this.includeFullEndTradingDay = false;
                return this;
            }
            case 1: {
                calendarFrom.add(5, -7);
                this.fromDate = calendarFrom.getTime();
                this.toDate = calendarFrom.getTime();
                this.includeFullEndTradingDay = false;
                return this;
            }
            case 2: {
                calendarFrom.add(5, -1);
                this.fromDate = calendarFrom.getTime();
                this.toDate = calendarFrom.getTime();
                this.includeFullEndTradingDay = true;
                return this;
            }
            case 3: {
                calendarFrom.add(5, -8);
                this.fromDate = calendarFrom.getTime();
                this.toDate = calendarFrom.getTime();
                this.includeFullEndTradingDay = true;
                return this;
            }
            case 4: {
                calendarFrom.add(5, -7);
                calendarFrom.setTime(DateTimeUtils.getStartDateForWeek((Date)calendarFrom.getTime()));
                calendarTo.setTime(DateTimeUtils.getEndDateForWeek((Date)calendarFrom.getTime()));
                this.fromDate = calendarFrom.getTime();
                this.toDate = calendarTo.getTime();
                this.includeFullEndTradingDay = true;
                return this;
            }
            case 5: {
                calendarFrom.setTime(DateTimeUtils.getStartDateForWeek((Date)calendarFrom.getTime()));
                calendarTo.add(5, -1);
                calendarTo.setTime(DateTimeUtils.getEndOfDay((Date)calendarTo.getTime()));
                this.fromDate = calendarFrom.getTime();
                this.toDate = calendarTo.getTime();
                this.includeFullEndTradingDay = true;
                return this;
            }
            case 6: {
                calendarFrom.setTime(DateTimeUtils.getStartDateForWeek((Date)calendarFrom.getTime()));
                this.fromDate = calendarFrom.getTime();
                this.toDate = calendarTo.getTime();
                this.includeFullEndTradingDay = false;
                return this;
            }
            case 7: {
                calendarFrom.set(5, 1);
                calendarFrom.add(2, -1);
                calendarTo.add(2, -1);
                calendarTo.set(5, calendarTo.getActualMaximum(5));
                this.fromDate = calendarFrom.getTime();
                this.toDate = calendarTo.getTime();
                this.includeFullEndTradingDay = false;
                return this;
            }
            case 8: {
                calendarFrom.set(5, 1);
                this.fromDate = calendarFrom.getTime();
                this.toDate = calendarTo.getTime();
                this.includeFullEndTradingDay = false;
                return this;
            }
            case 9: {
                calendarFrom.set(5, 1);
                calendarTo.add(5, -1);
                this.fromDate = calendarFrom.getTime();
                this.toDate = calendarTo.getTime();
                this.includeFullEndTradingDay = true;
                return this;
            }
        }
        return this;
    }

    SalesComparisonCompiler(Calendar referenceDate) {
        this.referenceDate = (Calendar)referenceDate.clone();
    }

    public TotalsReport doToday() {
        TradingDay today = this.getFirstTradingDayForDate(this.getReferenceDate().getTime());
        if (today == null) {
            return new TotalsReport();
        }
        return this.compileResults(today.getOpenDateTime(), this.getReferenceDate().getTime());
    }

    public TotalsReport doLastWeekSameTime() {
        Calendar cal = this.getReferenceDate();
        cal.add(5, -7);
        TradingDay start = this.getFirstTradingDayForDate(cal.getTime());
        if (start == null) {
            return new TotalsReport();
        }
        return this.compileResultsWithTime(start.getOpenDateTime(), cal.getTime());
    }

    public TotalsReport doYesterdayFull() {
        Calendar cal = this.getReferenceDate();
        cal.add(5, -1);
        TradingDay start = this.getFirstTradingDayForDate(cal.getTime());
        TradingDay end = this.getLastTradingDayForDate(cal.getTime());
        if (start == null || end == null) {
            return new TotalsReport();
        }
        return this.compileResults(start.getOpenDateTime(), this.getDateTo(end));
    }

    public TotalsReport doYesterdayLastWeekFull() {
        Calendar cal = this.getReferenceDate();
        cal.add(5, -8);
        TradingDay start = this.getFirstTradingDayForDate(cal.getTime());
        TradingDay end = this.getLastTradingDayForDate(cal.getTime());
        if (start == null || end == null) {
            return new TotalsReport();
        }
        return this.compileResults(start.getOpenDateTime(), this.getDateTo(end));
    }

    public TotalsReport doLastWeekFull() {
        int count;
        Calendar cal = this.getReferenceDate();
        cal.add(7, -7);
        cal.setTime(DateTimeUtils.getStartDateForWeek((Date)cal.getTime()));
        TradingDay start = this.getFirstTradingDayForDate(cal.getTime());
        for (count = 0; start == null && count < 7; ++count) {
            cal.add(5, 1);
            start = this.getFirstTradingDayForDate(cal.getTime());
        }
        cal.setTime(DateTimeUtils.getEndDateForWeek((Date)cal.getTime()));
        TradingDay end = this.getLastTradingDayForDate(cal.getTime());
        for (count = 0; end == null && count < 7; ++count) {
            cal.add(5, -1);
            end = this.getLastTradingDayForDate(cal.getTime());
        }
        if (start == null || end == null) {
            return new TotalsReport();
        }
        return this.compileResults(start.getOpenDateTime(), this.getDateTo(end));
    }

    public TotalsReport doWeekToYesterday() {
        Calendar cal = this.getReferenceDate();
        cal.setTime(DateTimeUtils.getStartDateForWeek((Date)cal.getTime()));
        TradingDay start = this.getFirstTradingDayForDate(cal.getTime());
        Calendar yesterday = this.getReferenceDate();
        yesterday.add(5, -1);
        yesterday.setTime(DateTimeUtils.getEndOfDay((Date)yesterday.getTime()));
        for (int count = 0; start == null && count < 7 && yesterday.compareTo(cal) > 0; ++count) {
            cal.add(5, 1);
            start = this.getFirstTradingDayForDate(cal.getTime());
        }
        if (start == null || start.getCloseDate() == null) {
            return new TotalsReport();
        }
        TradingDay end = this.getLastTradingDayForDate(yesterday.getTime());
        if (end == null || end.getCloseDateTime() == null || end.getCloseDateTime().compareTo(start.getOpenDateTime()) <= 0) {
            return new TotalsReport();
        }
        return this.compileResults(start.getOpenDateTime(), end.getCloseDateTime());
    }

    public TotalsReport doWeekToDate() {
        Calendar cal = this.getReferenceDate();
        Calendar today = this.getReferenceDate();
        cal.setTime(DateTimeUtils.getStartDateForWeek((Date)cal.getTime()));
        TradingDay start = this.getFirstTradingDayForDate(cal.getTime());
        for (int count = 0; start == null && count < 7 && today.compareTo(cal) > 0; ++count) {
            cal.add(5, 1);
            start = this.getFirstTradingDayForDate(cal.getTime());
        }
        if (start == null) {
            return new TotalsReport();
        }
        return this.compileResults(start.getOpenDateTime(), today.getTime());
    }

    public TotalsReport doLastMonth() {
        int count;
        Calendar cal = this.getReferenceDate();
        cal.set(5, 1);
        cal.add(2, -1);
        TradingDay start = this.getFirstTradingDayForDate(cal.getTime());
        for (count = 0; start == null && count < cal.getActualMaximum(5) - 1; ++count) {
            cal.add(5, 1);
            start = this.getFirstTradingDayForDate(cal.getTime());
        }
        if (start == null) {
            return new TotalsReport();
        }
        cal.set(5, cal.getActualMaximum(5));
        TradingDay end = this.getLastTradingDayForDate(cal.getTime());
        for (count = 0; end == null && count < cal.getActualMaximum(5) - 1; ++count) {
            cal.add(5, -1);
            end = this.getLastTradingDayForDate(cal.getTime());
        }
        return this.compileResults(start.getOpenDateTime(), this.getDateTo(end));
    }

    public TotalsReport doMonthToDate() {
        Calendar cal = this.getReferenceDate();
        cal.set(5, 1);
        TradingDay start = this.getFirstTradingDayForDate(cal.getTime());
        for (int count = 0; start == null && count < cal.getActualMaximum(5); ++count) {
            cal.add(5, 1);
            start = this.getFirstTradingDayForDate(cal.getTime());
        }
        if (start == null) {
            return new TotalsReport();
        }
        return this.compileResults(start.getOpenDateTime(), this.getReferenceDate().getTime());
    }

    public TotalsReport doMonthToYesterday() {
        Calendar cal = this.getReferenceDate();
        if (cal.get(5) == 1) {
            return new TotalsReport();
        }
        cal.set(5, 1);
        TradingDay start = this.getFirstTradingDayForDate(cal.getTime());
        for (int count = 0; start == null && count < cal.getActualMaximum(5); ++count) {
            cal.add(5, 1);
            start = this.getFirstTradingDayForDate(cal.getTime());
        }
        if (start == null) {
            return new TotalsReport();
        }
        Calendar modifiedReference = this.getReferenceDate();
        modifiedReference.add(5, -1);
        TradingDay yesterdays = this.getLastTradingDayForDate(modifiedReference.getTime());
        return this.compileResults(start.getOpenDateTime(), this.getDateTo(yesterdays));
    }

    public TotalsReport compileResults(Date fromThisDate, Date toThisDate) {
        if (fromThisDate == null || toThisDate == null) {
            return new TotalsReport();
        }
        TotalsReportSearcher searcher = new TotalsReportSearcher();
        searcher.getTradingDayRangeFilter().setStart((Comparable)fromThisDate);
        searcher.getTradingDayRangeFilter().setEnd((Comparable)toThisDate);
        TotalsReport totalReport = new TotalsReport();
        for (TotalsReport report : searcher.search()) {
            totalReport.setTotal(totalReport.getTotal().add(report.getTotal()));
            totalReport.setTotalTax(totalReport.getTotalTax().add(report.getTotalTax()));
        }
        return totalReport;
    }

    public TotalsReport compileResultsWithTime(Date fromThisDate, Date toThisDate) {
        if (fromThisDate == null || toThisDate == null) {
            return new TotalsReport();
        }
        TradingDay day = this.getFirstTradingDayForDate(fromThisDate);
        if (day == null) {
            return new TotalsReport();
        }
        TotalsReportSearcher searcher = new TotalsReportSearcher();
        searcher.getSalesDateTimeRangeFilter().setStart((Comparable)day.getOpenDateTime());
        searcher.getSalesDateTimeRangeFilter().setEnd((Comparable)toThisDate);
        TotalsReport totalReport = new TotalsReport();
        for (TotalsReport report : searcher.search()) {
            totalReport.setTotal(totalReport.getTotal().add(report.getTotal()));
            totalReport.setTotalTax(totalReport.getTotalTax().add(report.getTotalTax()));
        }
        return totalReport;
    }

    private TradingDay getFirstTradingDayForDate(Date fromThisDate) {
        return (TradingDay)PersistenceManager.getObject(TradingDay.class, (String)Query.select(TradingDay.class).greaterThanOrEqual(TradingDay.Properties.DATE, fromThisDate, SQLDateType.DATE).orderBy(TradingDay.Properties.DATE, false).orderBy(TradingDay.Properties.TIME, false).limit(1).toString());
    }

    private TradingDay getLastTradingDayForDate(Date fromThisDate) {
        return (TradingDay)PersistenceManager.getObject(TradingDay.class, (String)Query.select(TradingDay.class).lessThanOrEqual(TradingDay.Properties.DATE, fromThisDate, SQLDateType.DATE).orderBy(TradingDay.Properties.DATE, true).orderBy(TradingDay.Properties.TIME, true).limit(1).toString());
    }

    private Calendar getReferenceDate() {
        return (Calendar)this.referenceDate.clone();
    }

    private Date getDateTo(TradingDay end) {
        if (end == null || end.isOpen()) {
            return this.getReferenceDate().getTime();
        }
        return end.getCloseDateTime();
    }
}

