/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.reporting;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.filter.FixedPeriod;
import au.com.ordermate.util.Price;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.config.report.ReportConfig;
import ordermate.database.config.report.ReportConfigSchedule;
import ordermate.database.feedback.FeedbackAnswer;
import ordermate.database.feedback.FeedbackQuestion;
import ordermate.database.finance.reports.TotalsReport;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.StaffCostReportHelper;
import ordermate.database.reports.StaffCostReportSummary;
import ordermate.database.reports.dailysummary.DailyDebtorSummaryReport;
import ordermate.database.reports.dailysummary.DailyPatronsReport;
import ordermate.database.reports.dailysummary.DailyProductivitySummaryReport;
import ordermate.database.reports.dailysummary.DailyProductivitySummaryReportCompiler;
import ordermate.database.reports.dailysummary.DailyReportI;
import ordermate.database.reports.dailysummary.DailySalesSummaryReport;
import ordermate.database.reports.dailysummary.DailyVoucherSummaryReport;
import ordermate.database.reports.feedback.FeedbackReport;
import ordermate.database.reports.feedback.FeedbackReportSearcher;
import ordermate.database.reports.general.NumberReport;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.reports.sales.general.AdjustmentsTotalReport;
import ordermate.database.reports.sales.staff.StaffDeletedItemsReport;
import ordermate.database.searchers.reports.dailysummary.DailyDebtorSummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailyNumPatronsByAccountSearcher;
import ordermate.database.searchers.reports.dailysummary.DailyProductivitySummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailySalesSummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;
import ordermate.database.searchers.reports.dailysummary.DailyVoucherSummaryReportSearcher;
import ordermate.database.searchers.reports.sales.staff.StaffDeletionReportSearcher;
import ordermate.database.searchers.sales.AdjustmentsTotalSearcher;
import ordermate.encryption.BlowfishEasy;
import ordermate.integration.jaxb.report.SMReport;
import ordermate.integration.jaxb.report.SMReportList;
import ordermate.integration.jaxb.smreport.SMReportConfig;
import ordermate.integration.jaxb.smreport.SMReportSchedule;
import ordermate.jaxb.exporter.XMLHelper;
import ordermate.misc.ObjectMarshaller;
import ordermate.webresource.AbstractResource;
import servermate.servlets.reporting.SMReportCache;
import servermate.servlets.reporting.SalesComparisonCompiler;
import servermate.servlets.reporting.scheduling.SMReportSchedulingService;

@Path(value="")
public class ServermateReportingResource
extends AbstractResource {
    private static final Map<String, SMReportCache> cacheMap = new HashMap<String, SMReportCache>();
    protected static final String SALES = "sales-";
    protected static final String COMPARATIVE = "comparative-";
    protected static final String FEEDBACK = "feedback-";
    private final DecimalFormat format = new DecimalFormat("0");
    SMReportSchedulingService reportSchedulingService = new SMReportSchedulingService();

    @POST
    @Path(value="schedule")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response postSchedule(SMReportSchedule requestSchedule) {
        try {
            this.reportSchedulingService.validateReportSchedule(requestSchedule);
            SMReportConfig requestConfig = requestSchedule.getReportConfig();
            ConfigurableReportMaker<?, ?> reportMaker = this.reportSchedulingService.createMakerForType(requestConfig.getType());
            ReportConfig responseConfig = this.reportSchedulingService.createReportConfig(requestConfig, reportMaker);
            ReportConfigSchedule responseSchedule = this.reportSchedulingService.createReportSchedule(responseConfig, requestSchedule.getCronSchedule(), requestSchedule.getRecipients());
            return this.getCreatedResponse(requestSchedule);
        }
        catch (SMReportSchedulingService.ReportSchedulingException ex) {
            return this.getBadRequestResponse(ex.getReason());
        }
    }

    @Path(value="sales")
    @GET
    @Produces(value={"text/plain"})
    public String getAllReports(@QueryParam(value="fixedPeriod") String periodLabel, @QueryParam(value="includes") String includes, @QueryParam(value="mangle") String mangle) {
        if (periodLabel == null) {
            return null;
        }
        if (mangle == null || mangle.isEmpty()) {
            return null;
        }
        FixedPeriod period = this.findPeriod(periodLabel);
        if (period == null) {
            return null;
        }
        List locations = PersistenceManager.getObjectList(SalesLocation.class, (String)Query.select(SalesLocation.class).active(SalesLocation.class).toString());
        ArrayList<SMReportList> reports = new ArrayList<SMReportList>();
        reports.add(this.retrieveReport(period, null));
        if (!locations.isEmpty()) {
            for (SalesLocation location : locations) {
                reports.add(this.retrieveReport(period, location));
            }
        }
        ObjectMarshaller marshaller = new ObjectMarshaller();
        String data = marshaller.marshal(reports);
        BlowfishEasy bf = new BlowfishEasy(mangle);
        return bf.encryptString(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SMReportList retrieveReport(FixedPeriod period, SalesLocation location) {
        SMReportList reportList;
        if ("Today".equals(period.getLabel())) {
            SMReportCache cache;
            String cacheKey = SALES + period.getLabel();
            if (location != null) {
                cacheKey = cacheKey + location.getLabel();
            }
            if ((cache = this.getCache(cacheKey)).isStale() && cache.lock()) {
                try {
                    if (cache.isStale()) {
                        OrderMate.LOG.info("Populating cache for Today Snapshot");
                        reportList = this.doReports(period, location);
                        cache.setSMReportList(reportList, true);
                    }
                    OrderMate.LOG.info("Cache already updated for Today Snapshot");
                    reportList = new SMReportList();
                    cache.populateSMReportList(reportList);
                }
                finally {
                    cache.unlock();
                }
            } else {
                OrderMate.LOG.info("Using cache for Today Snapshot");
                reportList = new SMReportList();
                cache.populateSMReportList(reportList);
            }
        } else {
            OrderMate.LOG.info("No cache for Snapshot Report " + period);
            reportList = this.doReports(period, location);
        }
        return reportList;
    }

    private SMReportList doReports(FixedPeriod period, SalesLocation location) {
        DailySummaryReportParameters params = new DailySummaryReportParameters(Collections.EMPTY_LIST);
        params.getDateFilter().setStart((Comparable)period.getStartDate());
        params.getDateFilter().setEnd((Comparable)period.getEndDate());
        SMReportList reportList = new SMReportList();
        if (location != null) {
            params.getSalesLocationsFilter().setSearchValue((Object)location);
        }
        reportList.setDateFrom(XMLHelper.getDateType((Date)((Date)params.getDateFilter().getStart())));
        reportList.setDateTo(XMLHelper.getDateType((Date)((Date)params.getDateFilter().getEnd())));
        reportList.setFixedPeriod(period.getLabel());
        List reports = reportList.getReports();
        DailySalesSummaryReport sales = this.doSales(reports, params);
        this.doUsers(reports, params, sales);
        this.doDebtors(reports, params);
        this.doVouchers(reports, params);
        this.doMisc(reports, params);
        if (location != null) {
            SMReport salesLocationIdReport = new SMReport();
            salesLocationIdReport.setProperty("SalesLocation.ID");
            salesLocationIdReport.setValue(location.getID().toString());
            SMReport salesLocationReport = new SMReport();
            salesLocationReport.setValue(location.getLabel());
            salesLocationReport.setProperty("SalesLocation.Name");
            reports.add(salesLocationIdReport);
            reports.add(salesLocationReport);
        }
        return reportList;
    }

    private DailySalesSummaryReport doSales(List<SMReport> reports, DailySummaryReportParameters params) {
        DailySalesSummaryReportSearcher salesSearcher = new DailySalesSummaryReportSearcher();
        salesSearcher.setSearchParameters(params);
        SalesLocation location = null;
        if (!params.getSalesLocationsFilter().getSelectedOptions().isEmpty()) {
            location = (SalesLocation)params.getSalesLocationsFilter().getSelectedOptions().get(0);
        }
        DailySalesSummaryReport totalSalesReport = new DailySalesSummaryReport(null, location, null, "Total");
        for (DailySalesSummaryReport report : salesSearcher.search()) {
            totalSalesReport.add((DailyReportI)report);
        }
        reports.add(this.makeReport("Sales.TotalEx", (Number)totalSalesReport.getSalesEx()));
        reports.add(this.makeReport("Sales.TotalInc", (Number)totalSalesReport.getSalesInc()));
        reports.add(this.makeReport("Sales.TotalTax", (Number)totalSalesReport.getTax()));
        reports.add(this.makeReport("Sales.Refunds", (Number)totalSalesReport.getRefunds()));
        reports.add(this.makeReport("Sales.Discounts", (Number)totalSalesReport.getDiscounts()));
        reports.add(this.makeReport("Sales.Volume", totalSalesReport.getVolume()));
        AdjustmentsTotalSearcher adjustmentsSearcher = new AdjustmentsTotalSearcher();
        adjustmentsSearcher.getDateFilter().setStart((Comparable)params.getStart());
        adjustmentsSearcher.getDateFilter().setEnd((Comparable)params.getEnd());
        if (!params.getSalesLocationsFilter().getSelectedOptions().isEmpty()) {
            adjustmentsSearcher.getSalesLocationFilter().setSearchValue((Object)params.getSalesLocationsFilter().getSelectedOptions());
        }
        List surcharges = adjustmentsSearcher.search();
        Price price = Price.ZERO_DOLLAR;
        for (AdjustmentsTotalReport report : surcharges) {
            price = price.add(report.getSurcharges());
        }
        reports.add(this.makeReport("Sales.Surcharges", (Number)(price.compareTo(Price.ZERO_DOLLAR) != 0 ? price.negate() : price)));
        DailyNumPatronsByAccountSearcher numPatronsSearcher = new DailyNumPatronsByAccountSearcher();
        salesSearcher.setSearchParameters(params);
        numPatronsSearcher.setSearchParameters(params);
        DailyPatronsReport totalPatronsReport = new DailyPatronsReport();
        for (DailyPatronsReport report : numPatronsSearcher.search()) {
            totalPatronsReport.add((DailyReportI)report);
        }
        reports.add(this.makeReport("Sales.NumPatrons", totalPatronsReport.getNumPatrons()));
        if (totalPatronsReport.getNumPatrons() != 0) {
            reports.add(this.makeReport("Sales.DollarsPerPatron", (Number)totalSalesReport.getSalesInc().divide(totalPatronsReport.getNumPatrons())));
            reports.add(this.makeReport("Sales.DollarsPerPatronEx", (Number)totalSalesReport.getSalesEx().divide(totalPatronsReport.getNumPatrons())));
        } else {
            reports.add(this.makeReport("Sales.DollarsPerPatron", null));
            reports.add(this.makeReport("Sales.DollarsPerPatronEx", null));
        }
        return totalSalesReport;
    }

    private void doUsers(List<SMReport> reports, DailySummaryReportParameters params, DailySalesSummaryReport sales) {
        DailyProductivitySummaryReportSearcher searcher = new DailyProductivitySummaryReportSearcher();
        searcher.setTradingDayBySIQ(true);
        searcher.setSearchParameters(params);
        DailyProductivitySummaryReport prodReport = new DailyProductivitySummaryReport(null);
        List prodReports = searcher.search();
        for (DailyProductivitySummaryReport report : prodReports) {
            prodReport.add((DailyReportI)report);
        }
        DailyProductivitySummaryReportCompiler compiler = new DailyProductivitySummaryReportCompiler(params.getStart());
        List staffSummaries = params.getSalesLocationsFilter().getSelectedOptions().isEmpty() ? compiler.createStaffSummaries(new StaffCostReportHelper()) : compiler.createStaffSummaries(new StaffCostReportHelper(), params.getSalesLocationsFilter().getSelectedOptions());
        StaffCostReportSummaryInternal staffSummary = new StaffCostReportSummaryInternal();
        for (StaffCostReportSummary summary : staffSummaries) {
            staffSummary.add(summary);
        }
        prodReport.applySalesSummary(sales);
        prodReport.setStaffSummary((StaffCostReportSummary)staffSummary);
        reports.add(this.makeReport("Sales.Accounts", prodReport.getCount()));
        if (prodReport.getCount() != 0L) {
            reports.add(this.makeReport("Sales.AverageAccount", (Number)sales.getSalesInc().divide((Number)prodReport.getCount())));
            reports.add(this.makeReport("Sales.AverageAccountEx", (Number)sales.getSalesEx().divide((Number)prodReport.getCount())));
        }
        reports.add(this.makeReport("Users.TotalCost", (Number)prodReport.getLabourCost()));
        reports.add(this.makeReport("Users.TotalHours", prodReport.getLabourHours(), new DecimalFormat("0.00")));
        reports.add(this.makeReport("Users.SalesPerLabourHour", (Number)prodReport.getSalesPerLabourHour()));
    }

    private void doDebtors(List<SMReport> reports, DailySummaryReportParameters params) {
        DailyDebtorSummaryReportSearcher searcher = new DailyDebtorSummaryReportSearcher();
        searcher.setSearchParameters(params);
        DailyDebtorSummaryReport totalReport = new DailyDebtorSummaryReport(null);
        for (DailyDebtorSummaryReport nextReport : searcher.search()) {
            totalReport.add((DailyReportI)nextReport);
        }
        for (DailyDebtorSummaryReport nextReport : PersistenceManager.getObjectList(DailyDebtorSummaryReport.class, (String)searcher.getSalesQuery().toString())) {
            totalReport.add((DailyReportI)nextReport);
        }
        for (DailyDebtorSummaryReport nextReport : PersistenceManager.getObjectList(DailyDebtorSummaryReport.class, (String)searcher.getAdjustmentsQuery().toString())) {
            totalReport.add((DailyReportI)nextReport);
        }
        reports.add(this.makeReport("Debtor.Sales", (Number)totalReport.getSales()));
        reports.add(this.makeReport("Debtor.Payments", (Number)totalReport.getPayments()));
        reports.add(this.makeReport("Debtor.Discounts", (Number)totalReport.getDiscounts()));
        reports.add(this.makeReport("Debtor.Surcharges", (Number)totalReport.getSurcharges()));
    }

    private void doVouchers(List<SMReport> reports, DailySummaryReportParameters params) {
        DailyVoucherSummaryReportSearcher searcher = new DailyVoucherSummaryReportSearcher();
        searcher.setSearchParameters(params);
        DailyVoucherSummaryReport totalReport = new DailyVoucherSummaryReport(null);
        for (DailyVoucherSummaryReport nextReport : PersistenceManager.getObjectList(DailyVoucherSummaryReport.class, (String)searcher.getTopupsQuery().toString())) {
            totalReport.add((DailyReportI)nextReport);
        }
        for (DailyVoucherSummaryReport nextReport : PersistenceManager.getObjectList(DailyVoucherSummaryReport.class, (String)searcher.getRedeemsQuery().toString())) {
            totalReport.add((DailyReportI)nextReport);
        }
        for (DailyVoucherSummaryReport nextReport : PersistenceManager.getObjectList(DailyVoucherSummaryReport.class, (String)searcher.getTopupReversalsQuery().toString())) {
            totalReport.add((DailyReportI)nextReport);
        }
        for (DailyVoucherSummaryReport nextReport : PersistenceManager.getObjectList(DailyVoucherSummaryReport.class, (String)searcher.getRedeemReversalsQuery().toString())) {
            totalReport.add((DailyReportI)nextReport);
        }
        reports.add(this.makeReport("Voucher.Topups", (Number)totalReport.getTopups()));
        reports.add(this.makeReport("Voucher.TopupReversals", (Number)totalReport.getTopupReversals()));
        reports.add(this.makeReport("Voucher.Redeems", (Number)totalReport.getRedeems()));
        reports.add(this.makeReport("Voucher.RedeemReversals", (Number)totalReport.getRedeemReversals()));
    }

    private void doMisc(List<SMReport> reports, DailySummaryReportParameters params) {
        NumberReport report = (NumberReport)PersistenceManager.getObject(NumberReport.class, (String)Query.count(EventLogRecord.class, (String)"value").select(EventLogRecord.Properties.ID, "ID").equals(EventLogRecord.Properties.TRADING_DAY, (Object)TradingDay.getCurrentTradingDay()).equals(EventLogRecord.Properties.TYPE, (Object)"No Sale").joinLeft(Terminal.class, EventLogRecord.Properties.TERMINAL).wherePropertyIn(Terminal.Properties.SALES_LOCATION, (Collection)params.getSalesLocationsFilter().getSelectedOptions()).toString());
        reports.add(this.makeReport("Misc.NoSales", report.getValue()));
        StaffDeletionReportSearcher deletions = new StaffDeletionReportSearcher();
        deletions.getTradingDayDateRangeFilter().setStart((Comparable)params.getStart());
        deletions.getTradingDayDateRangeFilter().setEnd((Comparable)params.getEnd());
        deletions.getSalesLocationFilter().setSearchValue((Object)params.getSalesLocationsFilter().getSelectedOptions());
        double deletedValue = 0.0;
        double deletedQuantity = 0.0;
        for (StaffDeletedItemsReport deletedReport : deletions.search()) {
            deletedValue += deletedReport.getTotal().doubleValue();
            deletedQuantity += deletedReport.getQuantity().doubleValue();
        }
        reports.add(this.makeReport("Misc.DeletionsValue", deletedValue));
        reports.add(this.makeReport("Misc.DeletionsQty", deletedQuantity));
    }

    private SMReport makeReport(String property, Number value) {
        return this.makeReport(property, value, this.format);
    }

    private SMReport makeReport(String property, Number value, DecimalFormat formatter) {
        SMReport report = new SMReport();
        report.setProperty(property);
        report.setValue(value == null ? "0" : formatter.format(value.doubleValue()));
        return report;
    }

    @Path(value="comparisonreport")
    @GET
    @Produces(value={"text/plain"})
    public String getComparativeReport(@QueryParam(value="mangle") String mangle) {
        List locations = PersistenceManager.getObjectList(SalesLocation.class, (String)Query.select(SalesLocation.class).active(SalesLocation.class).toString());
        ArrayList<SMReportList> reports = new ArrayList<SMReportList>();
        reports.add(this.retrieveComparativeReport(null));
        if (!locations.isEmpty()) {
            for (SalesLocation location : locations) {
                OrderMate.LOG.info("Getting comparative report for location {}", (Object)location.getLabel());
                reports.add(this.retrieveComparativeReport(location));
            }
        }
        ObjectMarshaller marshaller = new ObjectMarshaller();
        String data = marshaller.marshal(reports);
        BlowfishEasy bf = new BlowfishEasy(mangle);
        return bf.encryptString(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public SMReportList retrieveComparativeReport(SalesLocation salesLocation) {
        cacheKey = "comparative-";
        if (salesLocation != null) {
            cacheKey = cacheKey + salesLocation.getLabel();
        }
        cache = this.getCache(cacheKey);
        cacheReports = new SMReportList();
        if (cache.isStale() && cache.lock()) {
            try {
                if (!cache.isStale()) ** GOTO lbl51
                freshReports = new SMReportList();
                if (salesLocation != null) {
                    salesLocationIdReport = new SMReport();
                    salesLocationIdReport.setProperty("Sales.SalesLocation.ID");
                    salesLocationIdReport.setValue(salesLocation.getID().toString());
                    salesLocationReport = new SMReport();
                    salesLocationReport.setValue(salesLocation.getLabel());
                    salesLocationReport.setProperty("Sales.SalesLocation.Name");
                    freshReports.getReports().add(salesLocationIdReport);
                    freshReports.getReports().add(salesLocationReport);
                }
                todayCalendar = Calendar.getInstance();
                today = new SalesComparisonCompiler().preset(todayCalendar.getTime(), 0).salesLocation(salesLocation).compile();
                lastWeek = new SalesComparisonCompiler().preset(todayCalendar.getTime(), 1).salesLocation(salesLocation).compile();
                this.addSnapshotReport(freshReports, "Today", today, "SameTimeLastWeek", lastWeek);
                if (cache.isRancid()) {
                    yesterdayFull = new SalesComparisonCompiler().preset(todayCalendar.getTime(), 2).salesLocation(salesLocation).compile();
                    yesterdayLastWeek = new SalesComparisonCompiler().preset(todayCalendar.getTime(), 3).salesLocation(salesLocation).compile();
                    weekToYesterday = new SalesComparisonCompiler().preset(todayCalendar.getTime(), 5).salesLocation(salesLocation).compile();
                    lastWeekFull = new SalesComparisonCompiler().preset(todayCalendar.getTime(), 4).salesLocation(salesLocation).compile();
                    monthToYesterday = new SalesComparisonCompiler().preset(todayCalendar.getTime(), 9).salesLocation(salesLocation).compile();
                    lastMonthFull = new SalesComparisonCompiler().preset(todayCalendar.getTime(), 7).salesLocation(salesLocation).compile();
                    this.addSnapshotReport(freshReports, "Yesterday", yesterdayFull, "YesterdayLastWeek", yesterdayLastWeek);
                    this.addSnapshotReport(freshReports, "WeekToYesterday", weekToYesterday, null, null);
                    this.addSnapshotReport(freshReports, "LastWeekFull", lastWeekFull, null, null);
                    this.addSnapshotReport(freshReports, "MonthToYesterday", monthToYesterday, null, null);
                    this.addSnapshotReport(freshReports, "LastMonthFull", lastMonthFull, null, null);
                    this.mergeSalesReports(freshReports, "WeekToYesterday", "Today", "WeekToDate");
                    this.mergeSalesReports(freshReports, "MonthToYesterday", "Today", "MonthToDate");
                    OrderMate.LOG.info("Comparative report - rancid cache");
                    cache.setSMReportList(freshReports, true);
                }
                OrderMate.LOG.info("Comparative report - stale cache");
                this.mergeSalesReports(freshReports, "WeekToYesterday", "Today", "WeekToDate");
                this.mergeSalesReports(freshReports, "MonthToYesterday", "Today", "MonthToDate");
                cache.setSMReportList(freshReports, false);
            }
            finally {
                cache.unlock();
            }
        } else {
            OrderMate.LOG.info("Comparative report - using cache");
        }
lbl51:
        // 4 sources

        cache.populateSMReportList(cacheReports);
        return cacheReports;
    }

    private void addSnapshotReport(SMReportList reports, String upper, TotalsReport upperReport, String lower, TotalsReport lowerReport) {
        String upperPrefix = "Sales." + upper;
        reports.getReports().add(this.makeReport(upperPrefix + ".Total", (Number)upperReport.getTotal()));
        reports.getReports().add(this.makeReport(upperPrefix + ".TotalEx", (Number)upperReport.getTotalEx()));
        if (lower != null) {
            String lowerPrefix = "Sales." + lower;
            reports.getReports().add(this.makeReport(lowerPrefix + ".Total", (Number)lowerReport.getTotal()));
            reports.getReports().add(this.makeReport(lowerPrefix + ".TotalEx", (Number)lowerReport.getTotalEx()));
            reports.getReports().add(this.makeReport(lowerPrefix + ".Comparison", (Number)upperReport.getTotal().subtract(lowerReport.getTotal())));
            reports.getReports().add(this.makeReport(lowerPrefix + ".ComparisonEx", (Number)upperReport.getTotalEx().subtract(lowerReport.getTotalEx())));
        }
    }

    private void mergeSalesReports(SMReportList reports, String first, String second, String as) {
        SMReport report;
        SMReport firstReportTotal = this.findReport(reports, "Sales." + first + ".Total");
        SMReport secondReportTotal = this.findReport(reports, "Sales." + second + ".Total");
        SMReport firstReportEx = this.findReport(reports, "Sales." + first + ".TotalEx");
        SMReport secondReportEx = this.findReport(reports, "Sales." + second + ".TotalEx");
        if (firstReportTotal != null && secondReportTotal != null) {
            report = new SMReport();
            report.setProperty("Sales." + as + ".Total");
            report.setValue(this.format.format(Price.parsePrice((String)firstReportTotal.getValue()).add(Price.parsePrice((String)secondReportTotal.getValue())).doubleValue()));
            reports.getReports().add(report);
        }
        if (firstReportEx != null && secondReportEx != null) {
            report = new SMReport();
            report.setProperty("Sales." + as + ".TotalEx");
            report.setValue(this.format.format(Price.parsePrice((String)firstReportEx.getValue()).add(Price.parsePrice((String)secondReportEx.getValue())).doubleValue()));
            reports.getReports().add(report);
        }
    }

    private SMReport findReport(SMReportList reports, String name) {
        for (SMReport report : reports.getReports()) {
            if (!report.getProperty().equals(name)) continue;
            return report;
        }
        return null;
    }

    @Path(value="feedback")
    @GET
    @Produces(value={"text/plain"})
    public String getFeedbackReport(@QueryParam(value="fixedPeriod") String periodLabel, @QueryParam(value="mangle") String mangle) {
        SMReportList reportList = new SMReportList();
        FixedPeriod period = this.findPeriod(periodLabel);
        if (period == null) {
            return null;
        }
        Date start = period.getStartDate();
        Date end = period.getEndDate();
        reportList.setDateFrom(XMLHelper.getDateType((Date)start));
        reportList.setDateTo(XMLHelper.getDateType((Date)end));
        reportList.setFixedPeriod(period.getLabel());
        SMReportCache cache = this.getCache(FEEDBACK + period.getLabel());
        if (cache.isStale()) {
            this.compileFeedbackReport(start, end, period, reportList.getReports());
            cache.setSMReportList(reportList, true);
        } else {
            cache.populateSMReportList(reportList);
        }
        ObjectMarshaller marshaller = new ObjectMarshaller();
        String data = marshaller.marshal((Object)reportList);
        if (!"NoMangle".equals(mangle)) {
            BlowfishEasy bf = new BlowfishEasy(mangle == null ? "" : mangle);
            return bf.encryptString(data);
        }
        return data;
    }

    private void compileFeedbackReport(Date start, Date end, FixedPeriod period, List<SMReport> reportList) {
        List questions = PersistenceManager.getObjectList(FeedbackQuestion.class, (String)Query.select(FeedbackQuestion.class).active(FeedbackQuestion.class).orderBy(FeedbackQuestion.Properties.ID).toString());
        FeedbackReportSearcher searcher = new FeedbackReportSearcher();
        searcher.getDateFilter().setStart((Comparable)start);
        searcher.getDateFilter().setEnd((Comparable)end);
        for (FeedbackQuestion nextQuestion : questions) {
            SMReport report = new SMReport();
            report.setProperty(("feedback." + period.getLabel() + "." + nextQuestion.getLabel()).replace(" ", "_"));
            searcher.getQuestionFilter().setSearchValue((Object)nextQuestion);
            StringBuilder valueBuilder = new StringBuilder();
            List searchResults = searcher.search();
            for (FeedbackAnswer answer : nextQuestion.getAnswers()) {
                valueBuilder.append(answer.getLabel()).append(":");
                long count = 0L;
                FeedbackReport result = null;
                for (FeedbackReport nextResult : searchResults) {
                    if (!answer.getID().equals(nextResult.getAnswerId())) continue;
                    result = nextResult;
                    break;
                }
                if (result != null) {
                    count = result.getCount();
                    searchResults.remove(result);
                }
                valueBuilder.append(count).append(",");
            }
            report.setValue(valueBuilder.toString());
            reportList.add(report);
        }
    }

    private FixedPeriod findPeriod(String periodLabel) {
        List defaultPeriods = FixedPeriod.getDefaultFixedPeriods();
        for (FixedPeriod nextPeriod : defaultPeriods) {
            if (!nextPeriod.getLabel().equalsIgnoreCase(periodLabel)) continue;
            return nextPeriod;
        }
        return null;
    }

    protected SMReportCache getCache(String key) {
        if (!cacheMap.containsKey(key)) {
            cacheMap.put(key, new SMReportCache());
        }
        return cacheMap.get(key);
    }

    public static void clearCaches() {
        cacheMap.clear();
    }

    class StaffCostReportSummaryInternal
    extends StaffCostReportSummary {
        StaffCostReportSummaryInternal() {
        }

        void add(StaffCostReportSummary value) {
            this.setTotalLabourHours(this.getTotalLabourHours() + value.getTotalLabourHours());
            this.setStaffCost(this.getStaffCost() != null ? this.getStaffCost().add(value.getStaffCost()) : value.getStaffCost());
        }
    }
}

