/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.stock;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import ordermate.OrderMate;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kxml2.io.KXmlSerializer;

class StockJsonXmlParser {
    private static final String BARCODE = "barcode";
    private static final String STOCKTAKE = "stocktake";
    private static final String STOCK_DATA = "stock_data";
    private KXmlSerializer serializer;

    StockJsonXmlParser() {
    }

    String convertJsonToXml(String object) {
        this.serializer = new KXmlSerializer();
        try {
            JSONObject obj = new JSONObject(object);
            JSONArray names = obj.names();
            if (STOCK_DATA.equals(names.get(0))) {
                return this.parseStockData(obj.getJSONObject(STOCK_DATA));
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot parse json", (Throwable)ex);
        }
        return null;
    }

    String parseStockData(JSONObject stockData) throws IOException, JSONException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializer.setOutput((OutputStream)out, null);
        this.serializer.startDocument(null, null);
        this.serializer.startTag(null, STOCK_DATA);
        if (stockData.has(BARCODE)) {
            this.doBarcodes(stockData.getJSONArray(BARCODE));
        }
        if (stockData.has(STOCKTAKE)) {
            this.doStockTake(stockData.getJSONObject(STOCKTAKE));
        }
        this.serializer.endTag(null, STOCK_DATA);
        this.serializer.endDocument();
        this.serializer.flush();
        out.flush();
        out.close();
        return new String(out.toByteArray());
    }

    private void doStockTake(JSONObject jsonObject) throws IOException, JSONException {
        this.serializer.startTag(null, STOCKTAKE);
        this.serializer.attribute(null, "id", jsonObject.getString("id"));
        this.serializer.attribute(null, "is_live", jsonObject.getString("is_live"));
        JSONArray entries = jsonObject.getJSONArray("entry");
        for (int i = 0; i < entries.length(); ++i) {
            JSONObject entry = entries.getJSONObject(i);
            this.serializer.startTag(null, "entry");
            this.serializer.attribute(null, "id", entry.getString("id"));
            this.serializer.attribute(null, "actual_qty", entry.getString("actual_qty"));
            this.serializer.attribute(null, "area", entry.getString("area"));
            this.serializer.attribute(null, "item", entry.getString("item"));
            this.serializer.endTag(null, "entry");
        }
        this.serializer.endTag(null, STOCKTAKE);
    }

    private void doBarcodes(JSONArray jsonArray) throws IOException, JSONException {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject barcode = jsonArray.getJSONObject(i);
            this.serializer.startTag(null, BARCODE);
            this.serializer.attribute(null, "item", barcode.getString("item"));
            this.serializer.attribute(null, "code", barcode.getString("code"));
            this.serializer.endTag(null, BARCODE);
        }
    }
}

