/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.stock;

import au.com.ordermate.OrderMateLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ordermate.OrderMate;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import org.json.JSONException;
import org.json.XML;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;
import servermate.servlets.ServerMateServlet;
import servermate.servlets.stock.ServermateStockSerializer;
import servermate.servlets.stock.ServermateStockSerializerV2;
import servermate.servlets.stock.StockJsonXmlParser;
import servermate.servlets.visitors.ServermateStockParser;

public class StockServlet
extends ServerMateServlet {
    private ServermateStockSerializer serializer = new ServermateStockSerializer();
    private ServermateStockSerializerV2 serializerV2;
    private ServermateStockParser parser = new ServermateStockParser();
    private Semaphore talkingStick = new Semaphore(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processGetRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        OrderMateLog.LOG.info("Stock information requested.");
        try {
            if (this.talkingStick.tryAcquire(30L, TimeUnit.SECONDS)) {
                if (request.getPathInfo() != null && request.getPathInfo().startsWith("/v2/")) {
                    this.doVersionTwo(request, response);
                } else {
                    this.doVersionOne(request, response);
                }
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error("Failed to acquire talking stick for Stock Servlet.", (Throwable)e);
        }
        finally {
            if (this.talkingStick.availablePermits() < 1) {
                this.talkingStick.release();
            }
        }
    }

    private void doVersionOne(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String output = null;
        if (!PersistentLicenseManager.getInstance().getBoolean(LicenseType.StockControlEnabled)) {
            output = "Stock Control is Not Licensed";
            response.setStatus(403);
            response.getWriter().write(output);
            response.getWriter().flush();
        } else {
            KXmlSerializer docSerializer = new KXmlSerializer();
            docSerializer.setOutput((Writer)response.getWriter());
            try {
                docSerializer.startDocument(null, null);
                this.serializer.serializeToXML(docSerializer);
                docSerializer.endDocument();
                docSerializer.flush();
                response.setStatus(200);
            }
            catch (XmlPullParserException ex) {
                OrderMateLog.LOG.warn("Stock information couldn't be serialized to XML.", (Throwable)ex);
                response.setStatus(500);
            }
        }
    }

    private void doVersionTwo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String output = null;
        if (!PersistentLicenseManager.getInstance().getBoolean(LicenseType.StockControlEnabled)) {
            output = "Stock Control is Not Licensed";
            response.setStatus(403);
        } else {
            if (this.serializerV2 == null) {
                this.serializerV2 = new ServermateStockSerializerV2();
            }
            StringWriter writer = new StringWriter();
            KXmlSerializer docSerializer = new KXmlSerializer();
            docSerializer.setOutput((Writer)writer);
            try {
                docSerializer.startDocument(null, null);
                this.serializerV2.serializeToXML(docSerializer);
                docSerializer.endDocument();
                docSerializer.flush();
            }
            catch (XmlPullParserException ex) {
                OrderMateLog.LOG.warn("Stock information couldn't be serialized to XML.", (Throwable)ex);
                response.setStatus(500);
            }
            output = writer.getBuffer().toString();
            try {
                output = XML.toJSONObject((String)output).toString(2);
                output = output.replace("&#10;", "\\n");
                response.setStatus(200);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        response.setContentType("application/json");
        response.getWriter().write(output);
        response.getWriter().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processPostRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String sendBack = null;
        response.setStatus(200);
        if (!PersistentLicenseManager.getInstance().getBoolean(LicenseType.StockControlEnabled)) {
            sendBack = "Stock Control is Not Licensed";
            response.setStatus(403);
        } else {
            try {
                if (this.talkingStick.tryAcquire(30L, TimeUnit.SECONDS)) {
                    OrderMateLog.LOG.info("Stock Data posted.");
                    sendBack = request.getContentType().contains("application/json") ? this.readInAsJSon(request, response) : (request.getContentType().contains("text/plain") ? this.readInAsText(request, response) : this.readInAsXml(request, response));
                }
            }
            catch (InterruptedException e) {
                OrderMate.LOG.error("Failed to acquire talking stick for Stock Servlet.", (Throwable)e);
            }
            finally {
                if (this.talkingStick.availablePermits() < 1) {
                    this.talkingStick.release();
                }
            }
        }
        if (sendBack != null) {
            sendBack = sendBack.trim();
            response.getWriter().print(sendBack);
            response.getWriter().flush();
        } else {
            response.getWriter().print("");
            response.getWriter().flush();
        }
    }

    private String readInAsXml(HttpServletRequest request, HttpServletResponse response) throws IOException {
        KXmlParser docParser = new KXmlParser();
        try {
            docParser.setInput((Reader)request.getReader());
            this.parser.parseFromXML(docParser);
            OrderMateLog.LOG.info("Posted Stock Data accepted - OK.");
            return this.parser.getTextualResponse();
        }
        catch (XmlPullParserException ex) {
            OrderMateLog.LOG.warn("Stock Information received couldn't be parsed. XML smells bad.", (Throwable)ex);
            response.setStatus(400);
            return null;
        }
    }

    private String readInAsJSon(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder SB = new StringBuilder();
        BufferedReader reader = request.getReader();
        String line = reader.readLine();
        while (line != null) {
            SB.append(line);
            line = reader.readLine();
        }
        OrderMate.LOG.info("JSON Received: \n" + SB.toString());
        String xml = new StockJsonXmlParser().convertJsonToXml(SB.toString());
        if (xml == null) {
            response.setStatus(400);
            return null;
        }
        OrderMate.LOG.info("Converted to XML: \n" + xml);
        KXmlParser docParser = new KXmlParser();
        try {
            docParser.setInput((Reader)new StringReader(xml));
            this.parser.parseFromXML(docParser);
            OrderMateLog.LOG.info("JSON Posted Stock Data accepted - OK.");
            return this.parser.getTextualResponse();
        }
        catch (XmlPullParserException ex) {
            OrderMateLog.LOG.warn("Stock Information received couldn't be parsed. XML smells bad.", (Throwable)ex);
            response.setStatus(400);
            return null;
        }
    }

    private String readInAsText(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = request.getReader();
        String line = reader.readLine();
        while (line != null) {
            sb.append(line).append("\n");
            line = reader.readLine();
        }
        OrderMate.LOG.info("Stock Logging Received: \n" + sb.toString());
        response.setStatus(200);
        return null;
    }
}

