/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.visitors;

import au.com.ordermate.OrderMateLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.stock.StockTake;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;
import servermate.servlets.visitors.StockTakeEntryVisitor;
import servermate.servlets.visitors.XMLTreeVisitor;

class StockTakeParser
extends XMLTreeVisitor<Void, StockTake> {
    private String returnMessage;

    StockTakeParser() {
    }

    @Override
    public void postVisit(Void parent, StockTake created) {
        if (created.isLive()) {
            created.save();
        } else {
            this.returnMessage = "Stocktake is known but has been closed, and cannot be updated.";
            OrderMateLog.LOG.warn(this.returnMessage);
        }
    }

    public String getTagName() {
        return "stocktake";
    }

    @Override
    protected List<XMLTreeVisitor<StockTake, ?>> createChildVisitors() {
        ArrayList list = new ArrayList();
        list.add(new StockTakeEntryVisitor());
        return list;
    }

    @Override
    protected StockTake parseXML(Void parentObject, KXmlParser docParser) throws IOException, XmlPullParserException {
        long id;
        StockTake take;
        String idValue = docParser.getAttributeValue(null, "id");
        if (idValue == null) {
            docParser.nextTag();
            idValue = docParser.nextText();
        }
        if ((take = StockTake.getStockTake((long)(id = Long.parseLong(idValue)))) == null) {
            throw new IllegalArgumentException("Stocktake id is unknown. Stocktake must be created before populating.");
        }
        return take;
    }

    @Override
    public String getReturnMessage() {
        return this.returnMessage;
    }

    @Override
    public void clearTextualResponse() {
        this.returnMessage = null;
    }
}

