/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.database.integration.bartabs.BarTabsConfiguration;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.integration.bartabs.BarTabAdministrator;
import ordermate.integration.bartabs.BarTabAuthority;
import ordermate.integration.bartabs.BarTabUpdateTask;

public class BarTabsIntegrationSetupTask
extends AbstractTask {
    public String getName() {
        return "Bar Tabs Integration Setup";
    }

    protected void performTask() throws Exception {
        if (PersistentLicenseManager.getInstance().getLicenseValue(LicenseType.WRBarTabs) == 1) {
            for (BarTabsConfiguration config : PersistenceManager.getObjectList(BarTabsConfiguration.class, (String)Query.select(BarTabsConfiguration.class).toString())) {
                BarTabAuthority auth;
                if (config == null || !config.isEnabled() || (auth = BarTabAdministrator.getInstance().getBarTabAuthorityForVendorId(config.getVendorId())) == null) continue;
                new Timer().schedule((TimerTask)new BarTabUpdateTask(auth), config.getPollInterval(), (long)config.getPollInterval());
            }
        }
    }

    protected int getTotalSubTasks() {
        return 1;
    }
}

