/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import org.apache.logging.log4j.Level;
import servermate.services.bevcon.BevConExporter;

public class BevConExportTask
extends AbstractTask {
    private static final int DEFAULT_DELAY = 10;
    private Timer timer;

    public String getName() {
        return "BevCon Export";
    }

    protected void performTask() throws Exception {
        BevConExporter exporter;
        ExperimentalFeature feature = ExperimentalFeature.find((String)"BevCon");
        if (feature == null || !feature.getBooleanValue(Boolean.FALSE).booleanValue()) {
            OrderMate.LOG.info("BevCon not enabled");
            return;
        }
        int minutes = Config.getIntValue((String)"BCTimer");
        if (minutes <= 0) {
            minutes = 10;
        }
        if ((exporter = BevConExporter.getInstance()).isValid()) {
            OrderMate.LOG.info("BevCon connection is viable, will sync every " + minutes + " minutes...");
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    BevConExporter.getInstance().performExport();
                }
            }, 100L, (long)minutes * 60000L);
        } else {
            OrderMate.LOG.log(Level.WARN, "Cannot start bevcon - not viable");
        }
    }

    protected int getTotalSubTasks() {
        return 1;
    }
}

