/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.guicore.task.TaskInterrupter;
import au.com.ordermate.persistence.PersistenceManager;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.startup.OrderMateSetupException;
import ordermate.startup.StartupManagerImpl;

public class CheckDatabaseTask
extends AbstractTask {
    private TaskInterrupter interrupter;
    private boolean forcedRepair = false;

    public CheckDatabaseTask(TaskInterrupter theInterrupter) {
        this.interrupter = theInterrupter;
    }

    public String getName() {
        return "Checking the database for errors";
    }

    public int getTotalSubTasks() {
        return 2;
    }

    protected void performTask() throws Exception {
        this.checkIndex();
        this.checkDatabase();
        this.emitProgress();
    }

    private void checkIndex() throws InterruptedException {
        new MissingIndexFixer((Task)this).check();
    }

    private void checkDatabase() {
        this.ensureTablesExist();
        StartupManagerImpl.setStatus((String)"Checking the database for errors");
        boolean dbOK = Data.checkDatabase((TaskInterrupter)this.interrupter);
        this.emitProgress();
        if (dbOK && !this.isForcedRepair()) {
            OrderMate.LOG.info("No errors found in the database");
        } else {
            if (!dbOK) {
                OrderMate.LOG.warn("Errors found in database, performing repair");
            }
            StartupManagerImpl.setStatus((String)"Errors were detected in the database, repair in progress");
            Data.repairAndOptimise((TaskInterrupter)this.interrupter);
        }
        StartupManagerImpl.setStatus((String)"Waiting for ServerMate to start");
    }

    private void ensureTablesExist() {
        Object[][] tableList;
        try {
            tableList = PersistenceManager.getPersistenceDelegate().executeQuery("SHOW TABLES", new Object[0]);
        }
        catch (Exception ex) {
            throw new OrderMateSetupException((Task)this, "An exception was thrown checking if tables exist in the database: " + ex.getMessage(), (Throwable)ex, true);
        }
        if (tableList == null || tableList.length == 0) {
            throw new OrderMateSetupException((Task)this, "No tables found in the database", new String[]{"Contact OrderMate Technical Support", "Prepare the database with datamate."}, true);
        }
    }

    public void setForcedRepair(boolean repair) {
        this.forcedRepair = repair;
    }

    public boolean isForcedRepair() {
        return this.forcedRepair;
    }

    public class MissingIndexFixer {
        private final File mysqlDataDirectory;
        private String mysqlBin;
        private static final String MYD_SUFFIX = ".MYD";
        private static final String MYI_SUFFIX = ".MYI";
        private final Task parentTask;

        public MissingIndexFixer(Task parent) {
            this.parentTask = parent;
            String dataPath = Config.getStringValue((String)"mysql_directory");
            if (dataPath == null || dataPath.trim().isEmpty()) {
                dataPath = "C:/mysql/5.5/data/ordermate_prod";
            }
            this.mysqlBin = Config.getStringValue((String)"mysql_bin");
            if (this.mysqlBin == null || this.mysqlBin.trim().isEmpty()) {
                this.mysqlBin = "C:/mysql/5.5/bin/";
            }
            this.mysqlDataDirectory = new File(dataPath);
        }

        public void check() throws InterruptedException {
            Set<String> missingIndexFiles = this.getMissingIndexFiles();
            if (missingIndexFiles == null) {
                OrderMate.LOG.warn("Could not find mysql data directory, indexes not checked");
                return;
            }
            if (!missingIndexFiles.isEmpty()) {
                CheckDatabaseTask.this.sendStatus(missingIndexFiles.size() + " missing indexes found, will attempt to fix");
                for (String missingIndex : missingIndexFiles) {
                    if (CheckDatabaseTask.this.interrupter != null && CheckDatabaseTask.this.interrupter.isInterrupt()) {
                        return;
                    }
                    CheckDatabaseTask.this.sendStatus("Check database is fixing missing index : " + missingIndex);
                    String cmd = this.getRepairCommand(missingIndex);
                    Process proc = null;
                    try {
                        proc = Runtime.getRuntime().exec(cmd);
                    }
                    catch (Exception e) {
                        OrderMate.LOG.error("Could not repair missing index file :" + missingIndex, (Throwable)e);
                    }
                    if (proc == null || proc.waitFor() == 0 || Config.getBooleanValue((String)"do_not_throw_index_missing_exception")) continue;
                    throw new OrderMateSetupException(this.parentTask, "Could not repair missing index", new String[]{"Servermate could not repair the missing index for the table : " + missingIndex, "Contact OrderMate Technical Support"}, false);
                }
            } else {
                OrderMate.LOG.info("No missing indexes found");
            }
        }

        protected String getRepairCommand(String missingIndexFile) {
            if (missingIndexFile.isEmpty()) {
                throw new IllegalArgumentException("Need some tables");
            }
            String username = Config.getDecryptedStringValue((String)"database_username");
            String password = Config.getDecryptedStringValue((String)"database_password");
            String cmd = this.mysqlBin + "mysqlcheck -u" + username + " -p" + password + " -r ordermate_prod " + missingIndexFile + " --use_frm";
            System.out.println(cmd);
            return cmd;
        }

        protected Set<String> getMissingIndexFiles() {
            Set<String> tables = this.getFileSet(this.mysqlDataDirectory, MYD_SUFFIX);
            Set<String> indexes = this.getFileSet(this.mysqlDataDirectory, MYI_SUFFIX);
            if (tables != null) {
                tables.removeAll(indexes);
            }
            return tables;
        }

        protected Set<String> getFileSet(File directory, final String suffix) {
            if (!directory.exists()) {
                OrderMate.LOG.warn("Directory does not exist : " + directory);
                return null;
            }
            File[] files = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(suffix);
                }
            });
            HashSet<String> frmSet = new HashSet<String>();
            for (File f : files) {
                String fileName = f.getName().substring(0, f.getName().length() - 4);
                frmSet.add(fileName);
            }
            return frmSet;
        }
    }
}

