/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.guicore.task.TaskInterrupter;
import datamate.DatabaseUpdater;
import java.sql.ResultSet;
import java.sql.SQLException;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.dbconnection.DatabaseControl;
import ordermate.startup.OrderMateSetupException;
import servermate.ServerMate;
import servermate.gui.TimedCancelDialog;

public class DatabaseVersionCheckTask
extends AbstractTask {
    private TaskInterrupter interrupter;

    public DatabaseVersionCheckTask(TaskInterrupter theInterrupter) {
        this.interrupter = theInterrupter;
    }

    public int getTotalSubTasks() {
        return 2;
    }

    public String getName() {
        return "Checking database version";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performTask() throws Exception {
        int databaseLevel;
        DatabaseControl dc = new DatabaseControl();
        try {
            databaseLevel = this.getCurrentVersion(dc);
        }
        finally {
            try {
                dc.disconnectDB();
            }
            catch (SQLException ex) {
                ServerMate.LOG.error("Couldn't close off the database control's connection:", (Throwable)ex);
            }
        }
        if (databaseLevel != OrderMate.REQUIRED_DATABASE_VERSION()) {
            String message = "Database version is out of date.The current version is " + databaseLevel + " but the required version is " + OrderMate.REQUIRED_DATABASE_VERSION() + ".";
            ServerMate.LOG.info(message);
            boolean canUpdate = Config.getBooleanValue((String)"update_db");
            if (!canUpdate) {
                ServerMate.LOG.info("Waiting for database update cancel.");
                TimedCancelDialog cancel = new TimedCancelDialog(20, message + "\nPress Cancel to stop the update.");
                canUpdate = cancel.start();
            }
            if (canUpdate) {
                this.statusMessage.emit((Object)"Checking database for errors");
                Data.checkDatabase((TaskInterrupter)this.interrupter);
                ServerMate.LOG.info("Start the database updater.");
                DatabaseUpdater updater = new DatabaseUpdater(new DatabaseControl());
                updater.progress.connect((Object)this, "gotLevelUpdate");
                updater.updateToLastLevel();
                this.emitProgress();
                Data.optimize();
                this.emitProgress();
            } else {
                throw new OrderMateSetupException((Task)this, "Wrong Database Version", "Database version is out of date. The current version is " + databaseLevel + " but the required version is " + OrderMate.REQUIRED_DATABASE_VERSION() + ".", new String[]{"Please contact your OrderMate representative."}, false);
            }
        }
        this.emitProgress();
    }

    public void gotLevelUpdate(Integer level) {
        this.sendStatus("Updating database, current level is " + level);
    }

    private int getCurrentVersion(DatabaseControl dc) {
        ResultSet result = null;
        Integer version = null;
        try {
            result = dc.executeQuery("SELECT Database_Revision FROM system_current_info", new Object[0]);
            if (result == null || !result.next()) {
                throw new OrderMateSetupException((Task)this, "Could not find system_current_info table", new String[]{"Contact OrderMate support", "Confirm that system_current_info_table exists", "Repair database"}, true);
            }
            version = result.getInt(1);
        }
        catch (Exception ex) {
            throw new OrderMateSetupException((Task)this, "Could not find system_current_info table", new String[]{"Contact OrderMate support", "Confirm that system_current_info_table exists", "Repair database"}, true);
        }
        if (version == null) {
            throw new OrderMateSetupException((Task)this, "No data in system_current_info table", new String[]{"Contact OrderMate support", "Confirm that data exists in the system_current_info table", "Restore backup database."}, true);
        }
        return version;
    }
}

