/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.simplermi.SimpleRMI;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.PropertyIntegrationType;
import ordermate.database.misc.enums.ReservationIntegrationType;
import ordermate.integration.diamondback.DiamondBackIntegrator;
import ordermate.integration.property.PiggyIntegrator;
import ordermate.integration.property.RMSIntegrator;
import ordermate.integration.property.StarfleetIntegrator;
import ordermate.integration.respak.RespakIntegrator;
import ordermate.integration.restaurantdiary.RDIntegrator;
import ordermate.services.store.StoreTagger;
import ordermate.startup.SetupLoyaltyTask;
import servermate.startup.MenuLogIntegrationTask;
import servermate.startup.OnlineIntegrationFileWatchTask;

public class IntegrationSetupTask
extends AbstractTask {
    public int getTotalSubTasks() {
        return 4;
    }

    public String getName() {
        return "Startup Property Management Adaptor";
    }

    protected void performTask() throws Exception {
        SystemProperty props = SystemProperty.getInstance();
        PropertyIntegrationType type = props.getPropertyIntegration();
        if (type.equals((Object)StarfleetIntegrator.TYPE)) {
            SimpleRMI.shareObject((Remote)new StarfleetIntegrator(), (String)"PropertyIntegrator");
        } else if (type.equals((Object)RMSIntegrator.TYPE)) {
            SimpleRMI.shareObject((Remote)new RMSIntegrator(), (String)"PropertyIntegrator");
        } else if (type.equals((Object)RespakIntegrator.TYPE)) {
            SimpleRMI.shareObject((Remote)new RespakIntegrator(), (String)"PropertyIntegrator");
        } else if (type.equals((Object)PiggyIntegrator.TYPE)) {
            SimpleRMI.shareObject((Remote)new PiggyIntegrator(), (String)"PropertyIntegrator");
        }
        this.emitProgress();
        IntegrationSetupTask.shareReservations();
        this.emitProgress();
        SetupLoyaltyTask setupLoyalty = new SetupLoyaltyTask((GuiHandler)new DummyGUIHandler());
        setupLoyalty.runLocal();
        this.emitProgress();
        if (SystemProperty.getInstance().isOnlineIntegrationFull()) {
            new Timer().schedule((TimerTask)new OnlineIntegrationFileWatchTask(), 10000L, 2000L);
        }
        SimpleRMI.shareObject((Remote)StoreTagger.getInstance(), (String)"StoreTagger");
        if (SystemProperty.getInstance().isOnlineIntegrationPrintDocketOnly()) {
            new Timer().schedule((TimerTask)new MenuLogIntegrationTask(), 10000L, 2000L);
        }
        this.emitProgress();
    }

    public static void shareReservations() throws RemoteException {
        ReservationIntegrationType resType;
        if (SimpleRMI.isSharingObject((String)"ReservationIntegrator")) {
            SimpleRMI.unshareObject((String)"ReservationIntegrator");
        }
        if ((resType = SystemProperty.getInstance().getReservationIntegration()) != null) {
            if (ReservationIntegrationType.RESTAURANTDIARY.equals((Object)resType)) {
                SimpleRMI.shareObject((Remote)RDIntegrator.getInstance(), (String)"ReservationIntegrator");
            } else if (ReservationIntegrationType.DIAMONDBACK.equals((Object)resType)) {
                SimpleRMI.shareObject((Remote)DiamondBackIntegrator.getInstance(), (String)"ReservationIntegrator");
            }
        }
    }
}

