/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import ordermate.OrderMate;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.cloudback.redback.RedBackClient;

public class NaggerCheckTask
extends AbstractTask {
    public String getName() {
        return "Checking nag_for_email flag";
    }

    protected int getTotalSubTasks() {
        return 0;
    }

    protected void performTask() throws Exception {
        OrderMate.LOG.info("Checking nag_for_email in RedBack");
        boolean currentNag = SystemCurrentInfo.getInstance().isNagForEmail();
        boolean rbNag = this.getStoreNag(SystemCurrentInfo.getInstance().getRedbackId());
        if (currentNag != rbNag) {
            OrderMate.LOG.info("Updating! nag_for_email is now set to " + rbNag);
            SystemCurrentInfo.getInstance().setNagForEmail(rbNag);
            SystemCurrentInfo.getInstance().save();
        }
    }

    protected boolean getStoreNag(long redBackID) {
        try {
            return new RedBackClient().getRedBackStoreNagFlag(redBackID);
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Failed to pull a store nag value for this store from RedBack! The POS will continue to function as normal.", (Throwable)e);
            return true;
        }
    }
}

