/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.config.webresource.WebResource;
import ordermate.database.config.webresource.WebResourceLogConfig;
import ordermate.database.config.webresource.WebResourceType;
import ordermate.database.config.webresource.WebResourceUser;
import ordermate.database.config.webresource.WebResourceUserLink;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.finance.debtors.implementation.SimpleDebtor;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.PrinterLocation;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalMode;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.inventory.ConfigDisplayProfile;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DriverAssignmentSettlementType;
import ordermate.database.misc.license.LicenseChanger;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.queries.config.webresource.WebResourceQueries;
import ordermate.database.queries.finance.debtors.DebtorQueries;
import ordermate.database.queries.hardware.PrinterGroupQueries;
import ordermate.database.sales.AccountType;
import ordermate.database.users.User;

public class OmOStartupTask
extends AbstractTask {
    public static final String DEBTOR_GROUP_NAME = "Online Ordering";
    public static final String OMO_LABEL = "OrderMate Online";
    public static final String GLOBAL = "Global";

    public String getName() {
        return OMO_LABEL;
    }

    protected void performTask() throws Exception {
        this.ensureLicensed();
        this.emitProgress();
        this.enableFullOnlineOrdering();
        this.emitProgress();
        if (this.createOmOInstance()) {
            this.emitProgress();
            this.addMode();
            this.emitProgress();
            this.linkProfiles();
            this.emitProgress();
            this.printerLocations();
            this.emitProgress();
        }
    }

    protected int getTotalSubTasks() {
        return 6;
    }

    private void ensureLicensed() {
        if (!PersistentLicenseManager.getInstance().getBoolean(LicenseType.WROnlineOrder)) {
            OrderMateLog.LOG.info("Web Resource online order licence wasn't enabled, now enabling.");
            new LicenseChanger(LicenseType.WROnlineOrder, 1).execute();
        }
        if (!PersistentLicenseManager.getInstance().getBoolean(LicenseType.OnlineOrderingIntegrationEnabled)) {
            OrderMateLog.LOG.info("Online Ordering Integration enabled (Site) licence wasn't enabled, now enabling.");
            new LicenseChanger(LicenseType.OnlineOrderingIntegrationEnabled, 1).execute();
        }
        OrderMateLog.LOG.info("Web Resource OO licenced.");
    }

    private void enableFullOnlineOrdering() {
        if (!SystemProperty.getInstance().isOnlineIntegrationFull()) {
            OrderMateLog.LOG.info("Online integration full wasn't provided, now providing.");
            SystemProperty.getInstance().setOnlineIntegrationFull(true);
            SystemProperty.getInstance().save();
        }
        OrderMateLog.LOG.info("OO full integration enabled.");
    }

    private AbstractDebtor createDebtorWithGroup() {
        AbstractDebtor debtor = (AbstractDebtor)PersistenceManager.getObject(AbstractDebtor.class, (String)DebtorQueries.getDebtorByLabel((String)OMO_LABEL).limit(1).toString());
        if (debtor == null) {
            OrderMateLog.LOG.info("OMO debtor not found! creating one with OO group.");
            debtor = new SimpleDebtor();
            debtor.setLabel(OMO_LABEL);
            debtor.setGroup(this.getOmODebtorGroup());
            debtor.save();
        }
        OrderMateLog.LOG.info("OMO debtor and group check done.");
        return debtor;
    }

    private DebtorGroup getOmODebtorGroup() {
        DebtorGroup group = (DebtorGroup)PersistenceManager.getObject(DebtorGroup.class, (String)DebtorQueries.getDebtorGroupWithName((String)DEBTOR_GROUP_NAME).limit(1).toString());
        if (group == null) {
            group = new DebtorGroup(DEBTOR_GROUP_NAME, "SIMPLE");
            group.save();
        }
        return group;
    }

    private boolean createOmOInstance() {
        List omos = PersistenceManager.getObjectList(OnlineIntegrationConfig.class, (String)Query.select(OnlineIntegrationConfig.class).equals(OnlineIntegrationConfig.Properties.LABEL, (Object)OMO_LABEL).toString());
        OnlineIntegrationConfig omo = null;
        if (omos != null && !omos.isEmpty()) {
            omo = this.getSingleOmOInstanceIfExists(omos);
        }
        boolean newInstanceCreated = false;
        if (omo == null) {
            omo = this.createOmOIntegrationConfig();
            this.setupDefaultOOWRConfig();
            newInstanceCreated = true;
        } else {
            if (omo.getPayOffDebtor() == null) {
                omo.setPayOffDebtor(this.createDebtorWithGroup());
            }
            omo.save();
            OrderMateLog.LOG.info("OO integration config for OMO already exists.");
        }
        this.createOmOUserAndLinkResources();
        this.disableAutoAssignDriverIfCloseAccBeforeDeliveryEnabled();
        return newInstanceCreated;
    }

    private void disableAutoAssignDriverIfCloseAccBeforeDeliveryEnabled() {
        if (SystemProperty.getInstance().getDriverAssignmentSettlement() == DriverAssignmentSettlementType.NONE) {
            OrderMateLog.LOG.info("Auto-Close Account Before Delivery is enabled. Disabling Auto Assign Driver for all drivers.");
            List drivers = User.getAllDrivers();
            for (User driver : drivers) {
                if (!driver.isAutoAssign()) continue;
                driver.setAutoAssign(false);
                driver.save();
            }
        }
    }

    private OnlineIntegrationConfig getSingleOmOInstanceIfExists(List<OnlineIntegrationConfig> omos) {
        if (omos.size() > 1) {
            for (int i = 1; i < omos.size(); ++i) {
                omos.get(i).delete();
            }
        }
        return omos.get(0);
    }

    private OnlineIntegrationConfig createOmOIntegrationConfig() {
        OnlineIntegrationConfig omo = new OnlineIntegrationConfig(OMO_LABEL);
        omo.setMenuComplianceVersion(OnlineIntegrationConfig.MenuComplianceVersion.Vers1_2);
        omo.setPayOffDebtor(this.createDebtorWithGroup());
        omo.save();
        OrderMateLog.LOG.info("OmO integration config created.");
        return omo;
    }

    private void createOmOUserAndLinkResources() {
        WebResourceUser omoUser = (WebResourceUser)PersistenceManager.getObject(WebResourceUser.class, (String)WebResourceQueries.getWebResourceUserByLabel((String)OMO_LABEL).limit(1).toString());
        if (omoUser == null) {
            omoUser = new WebResourceUser(OMO_LABEL);
            omoUser.setUsername(OMO_LABEL);
            omoUser.setPassword("37SquidInk10");
            omoUser.setGroup(GLOBAL);
        }
        for (WebResource defaultResource : this.getWebResourcesListForOmOUser()) {
            WebResourceUserLink wrUserLink = new WebResourceUserLink(defaultResource, omoUser);
            if (this.checkWebResourceLinkExistsForUser(omoUser, defaultResource)) continue;
            omoUser.getLinks().add(wrUserLink);
        }
        omoUser.save();
        OrderMateLog.LOG.info("New OMO user created and linked to default web resources.");
    }

    private boolean checkWebResourceLinkExistsForUser(WebResourceUser omoUser, WebResource wr) {
        if (omoUser.getLinks() == null || omoUser.getLinks().size() == 0) {
            return false;
        }
        for (WebResourceUserLink wrLink : omoUser.getLinks()) {
            if (!wrLink.getResource().equals((Object)wr)) continue;
            return true;
        }
        return false;
    }

    private void setupDefaultOOWRConfig() {
        WebResource resource = (WebResource)PersistenceManager.getObject(WebResource.class, (String)WebResource.getByType((WebResourceType)WebResourceType.OnlineOrder).active(WebResource.class).toString());
        resource.setIpRestricted(false);
        resource.setLogConfig((WebResourceLogConfig)PersistenceManager.getObject(WebResourceLogConfig.class, (String)WebResourceQueries.getWebResourceLogConfigByLevel((WebResourceLogConfig.LoggingLevel)WebResourceLogConfig.LoggingLevel.FULL).toString()));
        resource.save();
        OrderMateLog.LOG.info("Setup default OO web resource config done.");
    }

    public List<WebResource> getWebResourcesListForOmOUser() {
        ArrayList<WebResource> defaultResources = new ArrayList<WebResource>();
        defaultResources.add((WebResource)PersistenceManager.getObject(WebResource.class, (String)WebResource.getByType((WebResourceType)WebResourceType.CustomerSales).toString()));
        defaultResources.add((WebResource)PersistenceManager.getObject(WebResource.class, (String)WebResource.getByType((WebResourceType)WebResourceType.OnlineOrder).toString()));
        defaultResources.add((WebResource)PersistenceManager.getObject(WebResource.class, (String)WebResource.getByType((WebResourceType)WebResourceType.OnlinePayments).toString()));
        defaultResources.add((WebResource)PersistenceManager.getObject(WebResource.class, (String)WebResource.getByType((WebResourceType)WebResourceType.Printing).toString()));
        defaultResources.add((WebResource)PersistenceManager.getObject(WebResource.class, (String)WebResource.getByType((WebResourceType)WebResourceType.KioskSettings).toString()));
        return defaultResources;
    }

    private void addMode() {
        List terminals = Terminal.getAllWaiterMateTerminals();
        for (Terminal terminal : terminals) {
            if (terminal.getAvailableLogicallyConnectedCashDrawers().isEmpty()) continue;
            this.checkOnlineModeForTerminal(terminal);
        }
        OrderMateLog.LOG.info("Added OO mode for terminals.");
    }

    private void checkOnlineModeForTerminal(Terminal terminal) {
        int sequence = 0;
        boolean found = false;
        for (TerminalMode mode : terminal.getTerminalModes()) {
            found = found || "Online".equals(mode.getMode());
            sequence = Math.max(sequence, mode.getSequence());
        }
        if (!found) {
            TerminalMode mode = new TerminalMode("Online");
            mode.setSequence(sequence + 1);
            terminal.addTerminalMode(mode);
            terminal.save();
        }
    }

    private void linkProfiles() {
        OnlineIntegrationConfig omo = OnlineIntegrationConfig.getConfigFor((String)OMO_LABEL);
        omo.setInventoryProfile(this.getInventoryProfile(Terminal.getServerMateTerminal()));
        omo.save();
        OrderMateLog.LOG.info("Inventory profiles linked for OMO.");
    }

    private InventoryProfile getInventoryProfile(Terminal terminal) {
        InventoryProfile profile = InventoryProfile.getProfile((AccountType)AccountType.onlinePickupType, (Terminal)terminal);
        if (profile == null) {
            profile = InventoryProfile.getProfile((AccountType)AccountType.allType, (Terminal)terminal);
        }
        if (profile == null) {
            if (InventoryProfile.getAllProfiles() == null || InventoryProfile.getAllProfiles().size() == 0) {
                profile = new InventoryProfile();
                profile.setLabel("OnlineProfile");
                profile.save();
            }
            profile = (InventoryProfile)InventoryProfile.getAllProfiles().get(0);
            AccountType[] types = this.getAccountTypesForProfileLink();
            this.linkProfileToAccountTypes(types, profile, terminal);
        }
        return profile;
    }

    public AccountType[] getAccountTypesForProfileLink() {
        boolean isAll = false;
        for (ConfigDisplayProfile link : ConfigDisplayProfile.getAllDisplays()) {
            if (!AccountType.allType.toString().equals(link.getAccountType())) continue;
            isAll = true;
            break;
        }
        if (!isAll) {
            return new AccountType[]{AccountType.onlineDeliveryType, AccountType.onlinePickupType, AccountType.onlineTableType};
        }
        return new AccountType[]{AccountType.allType};
    }

    private void linkProfileToAccountTypes(AccountType[] types, InventoryProfile profile, Terminal terminal) {
        for (AccountType type : types) {
            ConfigDisplayProfile link = new ConfigDisplayProfile();
            link.setAccountType(type.getType());
            link.setInventoryProfile(profile);
            link.setDisplayName(type.getLabel());
            link.setTerminalLocation(terminal.getDefaultLocation());
            link.save();
        }
    }

    private void printerLocations() {
        Terminal terminal = Terminal.getServerMateTerminal();
        List groups = PrinterGroup.getPrinterGroups();
        for (PrinterGroup group : groups) {
            PrinterLocation location = (PrinterLocation)PersistenceManager.getObject(PrinterLocation.class, (String)PrinterGroupQueries.getPrinterLocation((AccountType)AccountType.allType, (PrinterGroup)group, (Terminal)terminal).toString());
            if (location != null) continue;
            for (AccountType type : AccountType.getOnlineAccountTypes()) {
                location = (PrinterLocation)PersistenceManager.getObject(PrinterLocation.class, (String)PrinterGroupQueries.getPrinterLocation((AccountType)type, (PrinterGroup)group, (Terminal)terminal).toString());
                if (location != null) continue;
                this.createPrinterLocationForAccountType(type, group, terminal);
            }
        }
        OrderMateLog.LOG.info("Printer locations checked up for OMO.");
    }

    private void createPrinterLocationForAccountType(AccountType type, PrinterGroup group, Terminal terminal) {
        PrinterLocation location = (PrinterLocation)PersistenceManager.getObject(PrinterLocation.class, (String)PrinterGroupQueries.getPrinterLocation((AccountType)type, (PrinterGroup)group, null).toString());
        if (location == null) {
            location = (PrinterLocation)PersistenceManager.getObject(PrinterLocation.class, (String)PrinterGroupQueries.getPrinterLocation((AccountType)type, null, null).toString());
        }
        VirtualPrinter printer = location != null ? location.getVirtualPrinter() : (VirtualPrinter)VirtualPrinter.getAllPrinters().get(0);
        location = new PrinterLocation();
        location.setAccountType(type.getType());
        location.setPrinterGroup(group);
        location.setTerminalLocation(terminal.getDefaultLocation());
        location.setVirtualPrinter(printer);
        location.save();
    }
}

