/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.ComponentFactory;
import au.com.ordermate.persistence.Persistence;
import au.com.ordermate.persistence.PersistenceDelegate;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.UnsafePersistence;
import au.com.ordermate.persistence.UnsafePersistenceWrapper;
import au.com.ordermate.persistence.cache.remote.RemoteCachePublisher;
import au.com.ordermate.persistence.database.DatabasePersistence;
import au.com.ordermate.persistence.database.LPAPersistenceDelegate;
import au.com.ordermate.persistence.database.datasourcefactory.DataSourceFactory;
import au.com.ordermate.persistence.synchronisation.PersistenceSyncInterceptor;
import au.com.ordermate.persistence.synchronisation.PersistenceSyncReceiver;
import au.com.ordermate.sql.Dialect;
import au.com.ordermate.sql.MySQLDialect;
import au.com.ordermate.sql.SQL;
import au.com.ordermate.util.Price;
import java.sql.SQLException;
import ordermate.OrderMate;
import ordermate.internationalization.Internationalization;
import ordermate.maps.AllMappings;
import ordermate.startup.OrderMateSetupException;
import servermate.ServermatePersistenceSharer;

public class PersistenceServerSetupTask
extends AbstractTask {
    private static final int MAX_CONNECTION_ATTEMPTS = 120;
    private static final int RETRY_SLEEP_TIME = 500;
    private boolean share;
    private UnsafePersistenceWrapper.LogStrategy errorStrategy;
    private DataSourceFactory dsFactory = null;

    public PersistenceServerSetupTask(boolean shareOverRMI) {
        this(shareOverRMI, UnsafePersistenceWrapper.LOG_EXCEPTIONS);
    }

    public PersistenceServerSetupTask(boolean shareOverRMI, UnsafePersistenceWrapper.LogStrategy logStrategy) {
        this.share = shareOverRMI;
        this.errorStrategy = logStrategy;
    }

    public void setDataSourceFactory(DataSourceFactory factory) {
        this.dsFactory = factory;
    }

    public int getTotalSubTasks() {
        return 3;
    }

    public String getName() {
        return "Startup persistence";
    }

    protected void performTask() throws Exception {
        if (SQL.hasDialect()) {
            SQL.clearDialect();
        }
        SQL.setDialect((Dialect)new MySQLDialect());
        boolean connected = false;
        RemoteCachePublisher publisher = new RemoteCachePublisher();
        DatabasePersistence dbPersist = null;
        for (int retries = 0; !connected && retries < 120; ++retries) {
            try {
                dbPersist = this.dsFactory == null ? new DatabasePersistence() : new DatabasePersistence(this.dsFactory);
                dbPersist.ping();
                dbPersist.setInvalidateCachePublisher(publisher);
                connected = true;
                continue;
            }
            catch (SQLException ex) {
                OrderMateLog.LOG.info("Attempting to connect to MySQL database: " + (retries + 1), (Throwable)ex);
                if (retries + 1 == 120) {
                    OrderMateLog.LOG.error("Unable to connect to SQL database after maximum retries.");
                    throw new OrderMateSetupException((Task)this, "Unable to connect to database", new String[]{"Check that the MySQL service is running", "Check the database configuration is correct"}, (Throwable)ex, true);
                }
                Thread.sleep(500L);
            }
        }
        PersistenceSyncReceiver.createInstance(dbPersist);
        PersistenceSyncInterceptor dbSync = new PersistenceSyncInterceptor(dbPersist);
        UnsafePersistenceWrapper wrapper = new UnsafePersistenceWrapper((UnsafePersistence)dbSync, this.errorStrategy);
        LPAPersistenceDelegate delegate = LPAPersistenceDelegate.createInstance((Persistence)wrapper);
        PersistenceManager.initialize((PersistenceDelegate)delegate);
        delegate.registerMappings(AllMappings.getMappings());
        if (dbPersist != null) {
            dbPersist.initialize((ComponentFactory)delegate);
        }
        this.emitProgress();
        try {
            Price.setDollarSign((String)Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot set localised dollar sign", (Throwable)ex);
        }
        ServermatePersistenceSharer.init(dbSync, publisher, this.share);
    }
}

