/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import ordermate.OrderMate;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.cloudback.nudge.NudgeHelper;
import ordermate.integration.cloudback.redback.RedBackClient;

public class RedBackSetupTask
extends AbstractTask {
    public String getName() {
        return "Updating RedBack ID";
    }

    protected int getTotalSubTasks() {
        return 0;
    }

    protected void performTask() throws Exception {
        Long result = this.getRedBackID(SystemCurrentInfo.getInstance().getUpdatemateId());
        if (result != null && result != 0L && SystemCurrentInfo.getInstance().getRedbackId() != result.longValue()) {
            OrderMate.LOG.info("Success! Setting " + result + " as the RedBack ID.");
            SystemCurrentInfo.getInstance().setRedbackId(result.longValue());
            SystemCurrentInfo.getInstance().save();
        }
        if (SystemCurrentInfo.getInstance().getRedbackId() == 0L) {
            SystemTray systemTray = SystemTray.getSystemTray();
            TrayIcon[] icons = systemTray.getTrayIcons();
            if (icons.length > 0) {
                icons[0].displayMessage("Caution", "Please set your store id", TrayIcon.MessageType.ERROR);
            }
        } else {
            new NudgeHelper().setNudgeServiceAsDefault();
        }
    }

    protected Long getRedBackID(long updatemateId) {
        try {
            return new RedBackClient().getRedBackId(updatemateId);
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Failed to pull a RedBack ID for this store from RedBack! The POS will continue to function as normal, however be aware that some advanced back-of-house features may not work correctly.", (Throwable)e);
            return null;
        }
    }
}

