/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.simplermi.SimpleRMI;
import java.rmi.Remote;
import ordermate.OrderMate;
import ordermate.serverconnection.updatemate.UpdateMateServiceImpl;
import servermate.ServerMate;
import servermate.updatemate.ServerMateSiteDataInterfaceImpl;
import updatemate.client.ClientUpdateWSClient;
import updatemate.client.SiteDataInterface;

public class ServerMateUpdateTask
extends AbstractTask {
    private static final long CHECK_TIMEOUT = 3600000L;
    private ClientUpdateWSClient clientUpdateWS;
    private Thread monitorThread;

    public ServerMateUpdateTask() {
        boolean disabled = Config.getBooleanValue((String)"UpdateMateDisabled");
        if (!disabled) {
            ServerMateSiteDataInterfaceImpl siteDataInterface = new ServerMateSiteDataInterfaceImpl();
            this.clientUpdateWS = new ClientUpdateWSClient(false, (SiteDataInterface)siteDataInterface);
        }
    }

    protected int getTotalSubTasks() {
        return 1;
    }

    public String getName() {
        return "Start the UpdateMate service";
    }

    protected void performTask() throws Exception {
        try {
            boolean disabled = Config.getBooleanValue((String)"UpdateMateDisabled");
            if (!disabled) {
                Runnable monitor = new Runnable(){

                    @Override
                    public void run() {
                        boolean keepGoing = true;
                        Thread thread = null;
                        while (keepGoing) {
                            if (thread == null || !thread.isAlive()) {
                                thread = new Thread((Runnable)ServerMateUpdateTask.this.clientUpdateWS, "UpdateMate Service");
                                thread.setDaemon(true);
                                thread.start();
                            }
                            try {
                                this.wait(3600000L);
                            }
                            catch (InterruptedException ex) {
                                OrderMate.LOG.warn("Updatemate Monitor Thread interrupted", (Throwable)ex);
                            }
                        }
                    }
                };
                this.monitorThread = new Thread(monitor);
                this.monitorThread.setDaemon(true);
                this.monitorThread.start();
                SimpleRMI.shareObject((Remote)new UpdateMateServiceImpl(this.clientUpdateWS), (String)"Update Mate");
                ServerMate.LOG.info("The UpdateMate service is activated through RMI.");
            } else {
                ServerMate.LOG.warn("UpdateMate is disabled into the config file.");
            }
        }
        catch (Exception ex) {
            ServerMate.LOG.warn("Got an exception starting the Updater", (Throwable)ex);
        }
        this.emitProgress();
    }

    public ClientUpdateWSClient getClientUpdateWS() {
        return this.clientUpdateWS;
    }
}

